<?php
use Reewards\Domain\ConcoursManager;

// Sous-menu Créer un concours
add_action('admin_menu', function() {
    

    // Sous-menu Créer un concours
    add_submenu_page(
        ' ', // ← Slug du menu principal
        __( 'Créer un concours', 'reewards' ),
        __( 'Créer un concours', 'reewards' ),
        'manage_options',
        'rewaardsc-create-concours',
        'rewaardsc_render_create_concours_page'
    );
});

function rewaardsc_render_create_concours_page() {
    $rewards_list = get_option('rewaards_concours_rewards_full', []);

    // Soumission du formulaire
    if (
        isset($_POST['rewaardsc_create_concours_nonce']) &&
        wp_verify_nonce(
            sanitize_text_field( wp_unslash( $_POST['rewaardsc_create_concours_nonce'] ) ),
            'rewaardsc_create_concours'
        )
    ) {
        // Vérification et sanitization des champs POST
        $nom           = isset($_POST['concours_nom']) ? sanitize_text_field( wp_unslash( $_POST['concours_nom'] ) ) : '';
        $date_start    = isset($_POST['concours_start']) ? sanitize_text_field( wp_unslash( $_POST['concours_start'] ) ) : '';
        $date_end      = isset($_POST['concours_end']) ? sanitize_text_field( wp_unslash( $_POST['concours_end'] ) ) : '';
        $winners_count = isset($_POST['concours_winners']) ? intval( wp_unslash( $_POST['concours_winners'] ) ) : 0;
        $participants   = [];

        if ( strtotime($date_end) <= strtotime($date_start) ) {
            echo '<div class="notice notice-error"><p>' . esc_html__('La date de fin doit être supérieure à la date de début.', 'reewards') . '</p></div>';
        } else {
            $rewards_selected = [];
            if ( isset($_POST['reward_id']) && is_array($_POST['reward_id']) ) {
            // Déséchappe et nettoie tout le tableau reward_id
            $reward_ids = array_map( 'intval', wp_unslash( $_POST['reward_id'] ) );

            foreach ( $reward_ids as $reward_index ) {
                if ( isset( $rewards_list[ $reward_index ] ) && isset($_POST['reward_qty'][ $reward_index ]) ) {
                    $qty = intval( wp_unslash( $_POST['reward_qty'][ $reward_index ] ) );
                        if ( $qty > 0 ) {
                            $rewards_selected[] = [
                                'nom'   => $rewards_list[$reward_index]['nom'],
                                'image' => $rewards_list[$reward_index]['image'],
                                'qty'   => $qty
                            ];
                        }
                    }
                }
            }

            // Utilisation de la classe ConcoursManager
            $data = [
                'nom'           => $nom,
                'start'         => $date_start,
                'end'           => $date_end,
                'winners_count' => $winners_count,
                'rewards'       => $rewards_selected,
                'concours_status' => 'en_cours' // Statut initial
            ];
            $post_id = \Reewards\Domain\ConcoursManager::create($data);

            if ( $post_id ) {
                wp_redirect( admin_url('admin.php?page=rewaardsc-liste-concours&created=1') );
                exit;
            } else {
                echo '<div class="notice notice-error"><p>' . esc_html__('Erreur lors de la création du concours.', 'reewards') . '</p></div>';
            }
        }
    }
    ?>
    <div class="wrap rewaardsc-create-concours rewaardsc-animate-card">
        <form method="post" style="max-width:800px; background:#fff; padding:20px;">
            <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Créer un concours', 'reewards'); ?></h2>
            <?php wp_nonce_field('rewaardsc_create_concours', 'rewaardsc_create_concours_nonce'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="concours_nom"><?php esc_html_e('Nom du concours', 'reewards'); ?></label></th>
                    <td><input type="text" name="concours_nom" id="concours_nom" class="regular-text" required></td>
                </tr>
                <tr>
                    <th><label for="concours_start"><?php esc_html_e('Date de début', 'reewards'); ?></label></th>
                    <td><input type="datetime-local" name="concours_start" id="concours_start" required></td>
                </tr>
                <tr>
                    <th><label for="concours_end"><?php esc_html_e('Date de fin (tirage au sort)', 'reewards'); ?></label></th>
                    <td><input type="datetime-local" name="concours_end" id="concours_end" required></td>
                </tr>
                <tr>
                    <th><label for="concours_winners"><?php esc_html_e('Nombre de gagnants', 'reewards'); ?></label></th>
                    <td><input type="number" name="concours_winners" id="concours_winners" min="1" value="1" required></td>
                </tr>
            </table>
            <h2 style="margin-top:30px;"><?php esc_html_e('Récompenses', 'reewards'); ?></h2>
            <div style="display:flex; flex-wrap:wrap; gap:15px;">
            <?php foreach ( $rewards_list as $index => $reward ) : ?>
                <div class="reward-card" data-index="<?php echo esc_attr($index); ?>" style="flex:1 1 180px; border:1px solid #ddd; border-radius:10px; padding:10px; text-align:center; box-shadow:0 2px 6px rgba(0,0,0,0.05); cursor:pointer; position:relative;">
                    <input type="checkbox" name="reward_id[]" value="<?php echo esc_attr($index); ?>" class="reward-checkbox" style="display:none;">
                    <div class="reward-checkmark" style="position:absolute; top:10px; right:10px; width:24px; height:24px; border-radius:50%; background:#4caf50; display:none; align-items:center; justify-content:center; color:white; font-weight:bold;">✓</div>
                    <div><img src="<?php echo esc_url($reward['image']); ?>" style="max-width:100px; margin-bottom:10px;"></div>
                    <div style="font-weight:bold; margin-bottom:5px;"><?php echo esc_html($reward['nom']); ?></div>
                    <div>
                        <label><?php esc_html_e('Quantité', 'reewards'); ?>:</label>
                        <input type="number" name="reward_qty[<?php echo esc_attr($index); ?>]" value="0" min="0" class="reward-qty" style="width:60px;">
                    </div>
                </div>
            <?php endforeach; ?>
            </div>
            <div style="margin-top:30px;">
                <?php submit_button(__('Créer le concours', 'reewards')); ?>
            </div>
        </form>
    </div>
    <?php
}
?>