<?php
// Empêcher l'accès direct au fichier
defined('ABSPATH') || exit;

use Reewards\Domain\ConcoursManager;


// Sous-menu Liste des concours
add_action('admin_menu', function() {

    // Sous-menu Liste (optionnel, sinon la page principale suffit)
    add_submenu_page(
        'rewaardsc-main',
        __('Concours', 'reewards'),
        __('Concours', 'reewards'),
        'manage_options',
        'rewaardsc-liste-concours',
        'rewaardsc_render_liste_page'
    );
});


function rewaardsc_render_liste_page() {
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Vous n\'avez pas les permissions nécessaires pour accéder à cette page.', 'reewards'));
    }

    // Création réussie
    if (isset($_GET['created']) && intval($_GET['created']) === 1) {// phpcs:ignore WordPress.Security.NonceVerification.Recommended
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Concours créé avec succès.', 'reewards') . '</p></div>';
    }
    //Tirage
    if (isset($_GET['draw_concours']) && current_user_can('manage_options')) {
        $concours_id = intval($_GET['draw_concours']);
        check_admin_referer('rewaardsc_draw_concours_' . $concours_id);

        // Appel du service de tirage
        \Reewards\Domain\TirageService::lancerTirage($concours_id);

        // Mettre à jour le statut du concours
        update_post_meta($concours_id, 'concours_status', 'termine');

        echo '<div class="notice notice-success"><p>' . esc_html__('Le tirage a été effectué et le concours est terminé.', 'reewards') . '</p></div>';
    }

    // Suppression
    if (isset($_GET['delete_concours']) && current_user_can('manage_options')) {
        $concours_id = intval($_GET['delete_concours']);
        check_admin_referer('rewaardsc_delete_concours_' . $concours_id);
        ConcoursManager::delete($concours_id);
        echo '<div class="notice notice-success"><p>' . esc_html__('Concours supprimé avec succès.', 'reewards') . '</p></div>';
    }

    // Marquer comme terminé
    if (isset($_GET['mark_termine']) && current_user_can('manage_options')) {
        $concours_id = intval($_GET['mark_termine']);
        check_admin_referer('rewaardsc_mark_termine_' . $concours_id);
        ConcoursManager::markTermine($concours_id);
        echo '<div class="notice notice-success"><p>' . esc_html__('Le concours a été marqué comme terminé et la date de fin a été mise à jour.', 'reewards') . '</p></div>';
    }

    // Filtres et pagination
    $status_filter = isset($_GET['status']) ? sanitize_text_field(wp_unslash($_GET['status'])) : '';
    $paged = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $posts_per_page = isset($_GET['posts_per_page']) ? max(1, intval($_GET['posts_per_page'])) : 10;

    $concours_query = ConcoursManager::getList($paged, $posts_per_page, $status_filter);
    ?>
    <div class="wrap rewaardsc-liste-concours">
        <div class="rewaardsc-filters-export">
            <form method="get">
                <input type="hidden" name="page" value="rewaardsc-liste-concours">
                <label for="status_filter"><?php esc_html_e('Filtrer par statut :', 'reewards'); ?></label>
                <select id="status_filter" name="status" onchange="this.form.submit()">
                    <option value=""><?php esc_html_e('Tous', 'reewards'); ?></option>
                    <option value="en_cours" <?php selected($status_filter, 'en_cours'); ?>><?php esc_html_e('En cours', 'reewards'); ?></option>
                    <option value="termine" <?php selected($status_filter, 'termine'); ?>><?php esc_html_e('Terminé', 'reewards'); ?></option>
                </select>
                <label for="posts_per_page_filter"><?php esc_html_e('Afficher :', 'reewards'); ?></label>
                <select id="posts_per_page_filter" name="posts_per_page" onchange="this.form.submit()">
                    <?php foreach ([10, 20, 50, 100] as $option) : ?>
                        <option value="<?php echo esc_attr($option); ?>" <?php selected($posts_per_page, $option); ?>>
                            <?php echo esc_html($option . ' ' . __('lignes', 'reewards')); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>

            <a style="margin: 10px;" href="<?php echo esc_url(admin_url('admin.php?page=rewaardsc-create-concours')); ?>" class="button button-primary">
                ➕ <?php esc_html_e('Créer un concours', 'reewards'); ?>
            </a>

            <?php
                $is_pro = \Reewards\Utils\License::isProUser();
                $has_plugin_pro_pdf = function_exists('rewaardsc_pro_export_pdf');
                $has_plugin_pro_csv = function_exists('rewaardsc_pro_export_csv');

                // PDF
                if ($is_pro && $has_plugin_pro_pdf) {
                    echo '<a style="margin: 10px;" href="' . esc_url(admin_url('admin.php?page=rewaardsc-liste-concours&export_pdf=1')) . '" class="button">📑 ' . esc_html__('Exporter en PDF', 'reewards') . '</a>';
                } elseif ($is_pro && !$has_plugin_pro_pdf) {
                    echo '<a style="margin: 10px;" href="#" class="button rewaardsc-pro-feature" data-feature="pro-missing">📑 ' . esc_html__('Exporter en PDF', 'reewards') . '</a>';
                } else {
                    echo '<a style="margin: 10px;" href="#" class="button rewaardsc-pro-feature" data-feature="export_pdf">📑 ' . esc_html__('Exporter en PDF', 'reewards') . '</a>';
                }

                // CSV
                if ($is_pro && $has_plugin_pro_csv) {
                    echo '<a style="margin: 10px;" href="' . esc_url(admin_url('admin.php?page=rewaardsc-liste-concours&export_csv=1')) . '" class="button">🗃️ ' . esc_html__('Exporter en CSV', 'reewards') . '</a>';
                } elseif ($is_pro && !$has_plugin_pro_csv) {
                    echo '<a style="margin: 10px;" href="#" class="button rewaardsc-pro-feature" data-feature="pro-missing">🗃️ ' . esc_html__('Exporter en CSV', 'reewards') . '</a>';
                } else {
                    echo '<a style="margin: 10px;" href="#" class="button rewaardsc-pro-feature" data-feature="export_csv">🗃️ ' . esc_html__('Exporter en CSV', 'reewards') . '</a>';
                }
                ?>

        </div>
        <div style="max-width:1200px; margin:0 auto; overflow-x:auto;">
            <table class="rewaardsc-table-concours">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Statut', 'reewards'); ?></th>
                        <th><?php esc_html_e('Nom', 'reewards'); ?></th>
                        <th><?php esc_html_e('Date de début', 'reewards'); ?></th>
                        <th><?php esc_html_e('Date de fin', 'reewards'); ?></th>
                        <th><?php esc_html_e('Participants', 'reewards'); ?></th>
                        <th><?php esc_html_e('Gagnants', 'reewards'); ?></th>
                        <th><?php esc_html_e('Récompenses', 'reewards'); ?></th>
                        <th><?php esc_html_e('Actions', 'reewards'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($concours_query->have_posts()) : while ($concours_query->have_posts()) : $concours_query->the_post();
                        $start         = get_post_meta(get_the_ID(), 'concours_start', true);
                        $end           = get_post_meta(get_the_ID(), 'concours_end', true);
                        $winners_count = get_post_meta(get_the_ID(), 'concours_winners_count', true);
                        $rewards       = get_post_meta(get_the_ID(), 'concours_rewards', true);
                        $participants  = get_post_meta(get_the_ID(), 'concours_participants', true);
                        $participants_count = is_array($participants) ? count($participants) : 0;
                        $status        = get_post_meta(get_the_ID(), 'concours_status', true);
                    ?>
                        <tr>
                            <td>
                                <?php 
                                if ($status === 'en_cours') {
                                    echo '<span class="rewaardsc-status rewaardsc-status-encours">' . esc_html__('En cours', 'reewards') . '</span>';
                                } elseif ($status === 'termine') {
                                    echo '<span class="rewaardsc-status rewaardsc-status-termine">' . esc_html__('Terminé', 'reewards') . '</span>';
                                } else {
                                    echo '<span>—</span>';
                                }
                                ?>
                            </td>
                            <td><?php the_title(); ?></td>
                            <td><?php echo esc_html(date_i18n('j F Y', strtotime($start))); ?></td>
                            <td><?php echo esc_html(date_i18n('j F Y', strtotime($end))); ?></td>
                            <td><?php echo intval($participants_count); ?></td>
                            <td><?php echo intval($winners_count); ?></td>
                            <td>
                                <?php 
                                    $rewards = maybe_unserialize($rewards);
                                    if (is_array($rewards) && !empty($rewards)) {
                                        foreach ($rewards as $reward) {
                                            if (isset($reward['qty'], $reward['nom'])) {
                                                echo esc_html($reward['qty'] . ' x ' . $reward['nom']) . '<br>';
                                            }
                                        }
                                    } else {
                                        echo esc_html__('Aucune récompense', 'reewards');
                                    }
                                ?>
                            </td>
                            <td>
                                <!-- Voir le concours -->
                                <a href="<?php echo esc_attr(wp_nonce_url(admin_url('admin.php?page=rewaardsc-view-concours&id=' . get_the_ID()))); ?>" 
                                class="rewaardsc-action-btn rewaardsc-view-btn">
                                <span class="dashicons dashicons-edit"></span> <?php esc_html_e('Voir / Modifier', 'reewards'); ?>
                                </a>
                                <!-- Faire le tirage au sort -->
                                <?php if ($status === 'en_cours') : ?>
                                    <a href="<?php echo esc_attr(wp_nonce_url(admin_url('admin.php?page=rewaardsc-liste-concours&draw_concours=' . get_the_ID()), 'rewaardsc_draw_concours_' . get_the_ID())); ?>" 
                                    class="rewaardsc-action-btn rewaardsc-draw-btn"
                                    onclick="return confirm('<?php esc_attr_e('Êtes-vous sûr de vouloir effectuer le tirage au sort pour ce concours ?', 'reewards'); ?>');">
                                    <span class="dashicons dashicons-awards"></span> <?php esc_html_e('Faire le Tirage', 'reewards'); ?>
                                    </a>
                                <?php endif; ?>
                                <!-- Supprimer le concours -->
                                <a href="<?php echo esc_attr(wp_nonce_url(admin_url('admin.php?page=rewaardsc-liste-concours&delete_concours=' . get_the_ID()), 'rewaardsc_delete_concours_' . get_the_ID())); ?>" 
                                class="rewaardsc-action-btn rewaardsc-delete-btn">
                                <span class="dashicons dashicons-trash"></span> <?php esc_html_e('Supprimer', 'reewards'); ?>
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; wp_reset_postdata(); else: ?>
                        <tr>
                            <td colspan="8" style="padding:15px; text-align:center;"><?php esc_html_e('Aucun concours trouvé.', 'reewards'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <!-- Pagination -->
            <div class="rewaardsc-pagination">
                <?php
                $total_pages = $concours_query->max_num_pages;
                if ($total_pages > 1){
                    $current_page = max(1, $paged);
                    echo '<div style="display:flex; gap:5px;">';
                    for ($i=1; $i<=$total_pages; $i++){
                        $args = [
                            'paged' => $i,
                            'page' => 'rewaardsc-liste-concours'
                        ];
                        if ($status_filter) $args['status'] = $status_filter;
                        if ($posts_per_page) $args['posts_per_page'] = $posts_per_page;
                        $url = add_query_arg($args, admin_url('admin.php'));
                        echo '<a href="'.esc_url($url).'" style="padding:5px 10px; border-radius:6px; text-decoration:none; border:1px solid #ccc;'.($i==$current_page?' background:#0073aa;color:#fff;':'').'">'.esc_html($i).'</a>';
                    }
                    echo '</div>';
                }
                ?>
            </div>
        </div>
    </div>
    
    <script>
    window.rewaardscProMessages = {
        export_csv: "<?php echo esc_js(__('L’export CSV est réservé aux utilisateurs PRO.', 'reewards')); ?>",
        export_pdf: "<?php echo esc_js(__('L’export PDF est réservé aux utilisateurs PRO.', 'reewards')); ?>",
        pro_missing: "<?php echo esc_js(__('Votre licence PRO est valide, mais le plugin PRO n\'est pas installé ou activé. Veuillez installer le plugin PRO pour accéder à cette fonctionnalité.', 'reewards')); ?>"
    };
    </script>
    <script>
        jQuery(document).on('click', '.rewaardsc-pro-feature[data-feature]', function(e) {
            e.preventDefault();
            if (typeof window.rewaardscProCheck === 'function') {
                var feature = jQuery(this).data('feature');
                var msg = window.rewaardscProMessages[feature] || window.rewaardscProMessages['pro_missing'];
                window.rewaardscProCheck(false, msg);
            }
        });
    </script>

    <script>
    window.rewaardscAdminI18n = {
        confirmDelete: "<?php echo esc_js(__('Êtes-vous sûr de vouloir supprimer ce concours ?', 'reewards')); ?>"
    };
    </script>

<?php 
}