<?php
// Empêcher l'accès direct au fichier
defined('ABSPATH') || exit;

// Sous-menu caché : accessible uniquement via un lien direct
add_action('admin_menu', function() {
    add_submenu_page(
        ' ', // Slug du menu principal
        __( 'Voir le concours', 'reewards' ),
        __( 'Voir le concours', 'reewards' ),
        'manage_options',
        'rewaardsc-view-concours',
        'rewaardsc_render_view_concours_page'
    );
});



function rewaardsc_render_view_concours_page() {
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Vous n\'avez pas les permissions nécessaires pour accéder à cette page.', 'reewards'));
    }

    if ( !isset($_GET['id']) ) {
        echo '<div class="notice notice-error"><p>' . esc_html__('Aucun concours spécifié.', 'reewards') . '</p></div>';
        return;
    }

    $concours_id = intval($_GET['id']);
    $post = get_post($concours_id);

    if ( !$post || $post->post_type !== 'rewaards_concours' ) {
        echo '<div class="notice notice-error"><p>' . esc_html__('Concours introuvable.', 'reewards') . '</p></div>';
        return;
    }

    // Suppression d'un participant
    if (
        isset($_GET['delete_participant']) &&
        isset($_GET['_wpnonce']) &&
        wp_verify_nonce(
            sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ),
            'delete_participant_' . $concours_id
        )
    ) {
        $participants = get_post_meta($concours_id, 'concours_participants', true);
        $delete_user_id = intval($_GET['delete_participant']);
        if ( !empty($participants) && is_array($participants) ) {
            $participants = array_filter($participants, function($p) use ($delete_user_id) {
                return $p['ID'] != $delete_user_id;
            });
            update_post_meta($concours_id, 'concours_participants', $participants);
            echo '<div class="notice notice-success"><p>' . esc_html__('Participant supprimé avec succès.', 'reewards') . '</p></div>';
        }
    }

    // --- DONNÉES ACTUELLES
    $start         = get_post_meta($concours_id, 'concours_start', true);
    $end           = get_post_meta($concours_id, 'concours_end', true);
    $winners_count = get_post_meta($concours_id, 'concours_winners_count', true);
    $current_rewards = get_post_meta($concours_id, 'concours_rewards', true); // [{nom,image,qty}, ...]
    $participants  = get_post_meta($concours_id, 'concours_participants', true);
    $winners       = get_post_meta($concours_id, 'concours_gagnants', true);

    // Bibliothèque de récompenses (globale)
    $rewards_list = get_option('rewaards_concours_rewards_full', []);

    // Mapping des récompenses sélectionnées (pour précocher) : clé = index rewards_list, valeur = qty
    $preselected = [];
    if (is_array($current_rewards) && is_array($rewards_list)) {
        foreach ($current_rewards as $cr) {
            foreach ($rewards_list as $idx => $cand) {
                if (
                    isset($cand['nom'], $cand['image'], $cr['nom'], $cr['image']) &&
                    $cand['nom'] === $cr['nom'] &&
                    $cand['image'] === $cr['image']
                ) {
                    $preselected[$idx] = max(1, intval($cr['qty']));
                    break;
                }
            }
        }
    }

    // --- SAUVEGARDE
    if( isset($_POST['rewaardsc_save_concours']) && check_admin_referer('rewaardsc_update_concours_' . $concours_id) ) {
        $title = isset($_POST['concours_title'])
            ? sanitize_text_field( wp_unslash( $_POST['concours_title'] ) )
            : '';

        $start_posted = isset($_POST['concours_start'])
            ? sanitize_text_field( wp_unslash( $_POST['concours_start'] ) )
            : '';

        $end_posted = isset($_POST['concours_end'])
            ? sanitize_text_field( wp_unslash( $_POST['concours_end'] ) )
            : '';

        $winners_posted = isset($_POST['concours_winners_count'])
            ? intval( wp_unslash( $_POST['concours_winners_count'] ) )
            : 0;

        // Update post + metas "générales"
        wp_update_post([
            'ID' => $concours_id,
            'post_title' => $title
        ]);
        update_post_meta($concours_id, 'concours_start', $start_posted);
        update_post_meta($concours_id, 'concours_end', $end_posted);
        update_post_meta($concours_id, 'concours_winners_count', $winners_posted);

        // --- RÉCOMPENSES (sélection + quantités)
        $rewards_selected = [];
        if ( isset($_POST['reward_id']) && is_array($_POST['reward_id']) ) {
            $reward_ids = array_map(
                'intval',
                wp_unslash( $_POST['reward_id'] )
            );

            foreach ( $reward_ids as $idx ) {
                $idx = intval($idx);
                if (isset($rewards_list[$idx])) {
                    $qty = isset($_POST['reward_qty'][$idx]) ? intval($_POST['reward_qty'][$idx]) : 0;
                    if ($qty < 1) { $qty = 1; } // sécurité serveur
                    $rewards_selected[] = [
                        'nom'   => $rewards_list[$idx]['nom'],
                        'image' => $rewards_list[$idx]['image'],
                        'qty'   => $qty
                    ];
                }
            }
        }
        update_post_meta($concours_id, 'concours_rewards', $rewards_selected);

        echo '<div class="notice notice-success"><p>' . esc_html__('Concours mis à jour avec succès.', 'reewards') . '</p></div>';

        // Recharger les données à l'écran après sauvegarde
        $start         = $start_posted;
        $end           = $end_posted;
        $winners_count = $winners_posted;
        $current_rewards = $rewards_selected;
        // Remettre le mapping pour l'affichage post-save
        $preselected = [];
        foreach ($current_rewards as $cr) {
            foreach ($rewards_list as $idx => $cand) {
                if ($cand['nom'] === $cr['nom'] && $cand['image'] === $cr['image']) {
                    $preselected[$idx] = max(1, intval($cr['qty']));
                    break;
                }
            }
        }
    }
    ?>
    <div class="wrap rewaardsc-wrap">
 
        <!-- Formulaire édition du concours (inclut récompenses) -->
        <form method="post" style="margin-bottom:30px;">
            <?php wp_nonce_field('rewaardsc_update_concours_' . $concours_id); ?>
            
            <div class="rewaardsc-edit-card rewaardsc-animate-card">
                <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Modifier le concours', 'reewards'); ?></h2>



                <table class="form-table">
                    <tr>
                        <th><label for="concours_title"><?php esc_html_e('Nom du concours', 'reewards'); ?></label></th>
                        <td><input type="text" name="concours_title" id="concours_title" value="<?php echo esc_attr($post->post_title); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label for="concours_start"><?php esc_html_e('Date de début', 'reewards'); ?></label></th>
                        <td><input type="datetime-local" name="concours_start" id="concours_start" value="<?php echo esc_attr(gmdate('Y-m-d\TH:i', strtotime($start))); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label for="concours_end"><?php esc_html_e('Date de fin', 'reewards'); ?></label></th>
                        <td><input type="datetime-local" name="concours_end" id="concours_end" value="<?php echo esc_attr(gmdate('Y-m-d\TH:i', strtotime($end))); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th><label for="concours_winners_count"><?php esc_html_e('Nombre de gagnants', 'reewards'); ?></label></th>
                        <td><input type="number" name="concours_winners_count" id="concours_winners_count" value="<?php echo intval($winners_count); ?>" class="small-text" min="1"></td>
                    </tr>
                </table>

                <!-- Récompenses -->
                <h3 style="margin-top:25px;"><?php esc_html_e('Récompenses', 'reewards'); ?></h3>
                <?php if (!empty($rewards_list)) : ?>
                    <div class="rewaardsc-rewards-grid ">
                        <?php foreach ($rewards_list as $idx => $r): 
                            $is_selected = array_key_exists($idx, $preselected);
                            $qty_val     = $is_selected ? max(1, intval($preselected[$idx])) : 0;
                        ?>
                            <div class="rewaardsc-reward-card <?php echo $is_selected ? 'selected' : ''; ?>" data-index="<?php echo esc_attr($idx); ?>">
                                <input type="checkbox" name="reward_id[]" value="<?php echo esc_attr($idx); ?>" class="reward-checkbox" <?php checked($is_selected); ?> style="display:none;">
                                <div class="reward-checkmark" <?php echo $is_selected ? '' : 'style="display:none;"'; ?>>✓</div>
                                <div class="rewaardsc-reward-thumb">
                                    <?php if(!empty($r['image'])): ?>
                                        <img src="<?php echo esc_url($r['image']); ?>" alt="<?php echo esc_attr($r['nom'] ?? ''); ?>">
                                    <?php else: ?>
                                        <div class="rewaardsc-reward-fallback">🎁</div>
                                    <?php endif; ?>
                                </div>
                                <div class="rewaardsc-reward-name"><?php echo esc_html($r['nom'] ?? ''); ?></div>
                                <div class="rewaardsc-reward-qty">
                                    <label><?php esc_html_e('Quantité', 'reewards'); ?></label>
                                    <input type="number" name="reward_qty[<?php echo esc_attr($idx); ?>]" class="reward-qty" min="0" value="<?php echo esc_attr($qty_val); ?>">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p><?php esc_html_e('Aucune récompense disponible. Créez-en une d’abord.', 'reewards'); ?></p>
                <?php endif; ?>

                <p style="margin-top:20px;">
                    <input type="submit" name="rewaardsc_save_concours" class="button button-primary" value="<?php esc_html_e('Mettre à jour le concours', 'reewards'); ?>">
                </p>
            </div>
        </form>


        <!-- Gagnants -->
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Gagnants', 'reewards'); ?></h2>

        <?php if(!empty($winners)): ?>
            <div class="rewaardsc-table-responsive">
            <table class="widefat striped rewaardsc-participants-table rewaardsc-animate-card">
                <thead>
                    <tr>
                        <th><?php esc_html_e('ID', 'reewards'); ?></th>
                        <th><?php esc_html_e('Pseudo', 'reewards'); ?></th>
                        <th><?php esc_html_e('Email', 'reewards'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($winners as $winner): ?>
                        <tr>
                            <td><?php echo esc_html($winner['ID']); ?></td>
                            <td><?php echo esc_html($winner['pseudo']); ?></td>
                            <td><?php echo esc_html($winner['email']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            </div>
        <?php else: ?>
            <p><?php esc_html_e('Aucun gagnant tiré au sort pour ce concours.', 'reewards'); ?></p>
        <?php endif; ?>

        <!-- Participants -->
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Participants', 'reewards'); ?></h2>
        <?php if(!empty($participants)): ?>
            <div class="rewaardsc-table-responsive">
            <table class="widefat striped rewaardsc-participants-table rewaardsc-animate-card">
                <thead>
                    <tr>
                        <th><?php esc_html_e('ID', 'reewards'); ?></th>
                        <th><?php esc_html_e('Pseudo', 'reewards'); ?></th>
                        <th><?php esc_html_e('Email', 'reewards'); ?></th>
                        <th><?php esc_html_e('Actions', 'reewards'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($participants as $participant): ?>
                        <tr>
                            <td><?php echo esc_html($participant['ID']); ?></td>
                            <td><?php echo esc_html($participant['pseudo']); ?></td>
                            <td><?php echo esc_html($participant['email']); ?></td>
                            <td>
                                <?php 
                                $delete_url = wp_nonce_url(
                                    admin_url('admin.php?page=rewaardsc-view-concours&id=' . $concours_id . '&delete_participant=' . $participant['ID']),
                                    'delete_participant_' . $concours_id
                                );

                                $user_id = $participant['ID'];
                                $profile_url = get_edit_user_link($user_id);


                                ?>
                                <a href="<?php echo esc_url($profile_url); ?>" class="button button-small rewaardsc-btn-profile" target="_blank" style="margin-right:6px;" >
                                    <?php esc_html_e('Voir le profil', 'reewards'); ?>
                                </a> 
                                <a href="<?php echo esc_url($delete_url); ?>" class="button button-small button-danger" onclick="return confirm('<?php esc_html_e('Voulez-vous vraiment supprimer ce participant ?', 'reewards'); ?>');">
                                    🗑️ <?php esc_html_e('Supprimer', 'reewards'); ?>
                                </a> 
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            </div>
        <?php else: ?>
            <p><?php esc_html_e('Aucun participant pour ce concours.', 'reewards'); ?></p>
        <?php endif; ?>
        <br>
        <p><a href="<?php echo esc_url(admin_url('admin.php?page=rewaardsc-liste-concours')); ?>" class="button"><?php esc_html_e('Retour à la liste des concours', 'reewards'); ?></a></p>

        <style>
            .rewaardsc-table-responsive {
            width: 100%;
            overflow-x: auto;
        }

        .rewaardsc-table-responsive table {
            min-width: 600px;
        }
        </style>
    
    </div>
    <?php
}