<?php
// Empêcher l'accès direct au fichier
defined('ABSPATH') || exit;

// Pour uploader une image via la médiathèque WP
add_action('admin_enqueue_scripts', function($hook) {
    
    if ( isset($_GET['page']) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $page = sanitize_text_field( wp_unslash( $_GET['page'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

        if ( $page === 'rewaardsc-create-reward' ) {
            wp_enqueue_media();
            wp_enqueue_script(
                'rewaardsc-reward-admin',
                plugins_url('../assets/js/reward-admin.js', __FILE__),
                ['jquery'],
                filemtime(plugin_dir_path(__FILE__) . '../assets/js/reward-admin.js'),
                true
            );
        }
    }
});

// Sous-menu Créer une récompense
add_action('admin_menu', function() {
    add_submenu_page(
        'rewaardsc-main', // Slug du menu principal
        __( 'Récompenses', 'reewards' ),
        __( 'Récompenses', 'reewards' ),
        'manage_options',
        'rewaardsc-create-reward',
        'rewaardsc_render_create_reward_page'
    );
});

function rewaardsc_render_create_reward_page() {
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Vous n\'avez pas les permissions nécessaires pour accéder à cette page.', 'reewards'));
    }

    $rewards = get_option('rewaards_concours_rewards_full', []);

    // Ajout de récompense
    if (
        isset($_POST['rewaardsc_reward_nonce']) &&
        wp_verify_nonce(
            sanitize_text_field( wp_unslash( $_POST['rewaardsc_reward_nonce'] ) ),
            'rewaardsc_create_reward'
        )
    ) {
        
        $nom   = isset($_POST['reward_nom']) ? sanitize_text_field( wp_unslash( $_POST['reward_nom'] ) ) : '';
        $image = isset($_POST['reward_image']) ? esc_url_raw( wp_unslash( $_POST['reward_image'] ) ) : '';

        if ($nom && $image) {
            $rewards[] = [
                'nom' => $nom,
                'image' => $image
            ];
            update_option('rewaards_concours_rewards_full', $rewards);
            echo '<div class="notice notice-success"><p>' . esc_html__('Récompense ajoutée avec succès.', 'reewards') . '</p></div>';
        } else {
            echo '<div class="notice notice-error"><p>' . esc_html__('Veuillez remplir tous les champs.', 'reewards') . '</p></div>';
        }
    }

    // Suppression de récompense
    if (
        isset($_POST['delete_reward_nonce']) &&
        wp_verify_nonce(
            sanitize_text_field( wp_unslash( $_POST['delete_reward_nonce'] ) ),
            'rewaardsc_delete_reward'
        )
    ) {
        // Vérifie que l'index est bien présent
        $index = isset($_POST['reward_index']) ? intval( wp_unslash( $_POST['reward_index'] ) ) : 0;
        if (isset($rewards[$index])) {
            unset($rewards[$index]);
            $rewards = array_values($rewards);
            update_option('rewaards_concours_rewards_full', $rewards);
            echo '<div class="notice notice-success"><p>' . esc_html__('Récompense supprimée avec succès.', 'reewards') . '</p></div>';
        }
    }
    ?>

    <div class="wrap">
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Créer une récompense', 'reewards'); ?></h2>
        <div  style=" padding:20px; border-radius:12px; margin-bottom:30px;">
            <form method="post">
                <?php wp_nonce_field('rewaardsc_create_reward', 'rewaardsc_reward_nonce'); ?>
                <table class="form-table">
                    <tr>
                        <th style="width:150px;"><label for="reward_nom"><?php esc_html_e('Nom de la récompense', 'reewards'); ?></label></th>
                        <td><input type="text" name="reward_nom" id="reward_nom" class="regular-text" required style="padding:8px; border-radius:6px; border:1px solid #ccc;"></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e('Image de la récompense', 'reewards'); ?></th>
                        <td>
                            <input type="hidden" name="reward_image" id="reward_image" value="">
                            <button type="button" class="button" id="upload_image_button" style="margin-bottom:10px;"><?php esc_html_e('Choisir une image', 'reewards'); ?></button>
                            <div id="reward_image_preview" style="margin-top:10px;"></div>
                        </td>
                    </tr>
                </table>
                <?php submit_button(__('Ajouter la récompense', 'reewards')); ?>
            </form>
        </div>

        <?php if (!empty($rewards)) : ?>
            <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Récompenses existantes', 'reewards'); ?></h2>
            <table class="wp-list-table widefat fixed striped rewaardsc-animate-card" style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr>
                        <th style="width:100px;"><?php esc_html_e('Image', 'reewards'); ?></th>
                        <th><?php esc_html_e('Nom', 'reewards'); ?></th>
                        <th style="width:120px;"><?php esc_html_e('Actions', 'reewards'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rewards as $index => $r) : ?>
                        <tr>
                            <td>
                                <img src="<?php echo esc_url($r['image']); ?>" alt="" style="max-width:80px; height:auto; border-radius:6px;">
                            </td>
                            <td style="font-weight:bold; vertical-align:middle;">
                                <?php echo esc_html($r['nom']); ?>
                            </td>
                            <td style="vertical-align:middle;">
                                <form method="post" class="delete-reward-form" style="margin:0;">
                                    <?php wp_nonce_field('rewaardsc_delete_reward', 'delete_reward_nonce'); ?>
                                    <input type="hidden" name="reward_index" value="<?php echo esc_attr($index); ?>">
                                    <button type="submit" class="button rewaardsc-delete-reward-btn">
                                        <?php esc_html_e('Supprimer', 'reewards'); ?>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p><?php esc_html_e('Aucune récompense ajoutée pour le moment.', 'reewards'); ?></p>
        <?php endif; ?>
    </div>
    <?php
}