<?php
// Protection contre l'accès direct
defined('ABSPATH') || exit;

// Ajoute "Réglages" comme sous-menu du menu principal déjà existant
add_action('admin_menu', function () {
    // Menu principal
    if (!isset($GLOBALS['rewaardsc_menu_added'])) {
        add_menu_page(
            esc_html__('REEWARDS', 'reewards'),
            esc_html__('REEWARDS', 'reewards'),
            'manage_options',
            'rewaardsc-main',
            'rewaardsc_render_settings_page', // ou null si vous voulez une page vide principale
            'dashicons-awards',
            25
        );
        $GLOBALS['rewaardsc_menu_added'] = true;
        remove_submenu_page('rewaardsc-main', 'rewaardsc-main');
    }

    add_submenu_page(
        'rewaardsc-main', // ← Slug du menu principal existant
        esc_html__('Réglages', 'reewards'),
        esc_html__('Réglages', 'reewards'),
        'manage_options',
        'rewaardsc-settings', // Slug unique pour la page réglages
        'rewaardsc_render_settings_page'
    );
});

// Supprime le sous-menu automatique "REEWARDS"
add_action('admin_menu', function () {
    remove_submenu_page('rewaardsc-main', 'rewaardsc-main');
}, 999);

// Inclusion dynamique des callbacks d'enregistrement de chaque onglet
add_action('admin_init', function () {
    $tabs = ['general', 'design', 'emails', 'pro'];
    foreach ($tabs as $tab) {
        $file = __DIR__ . '/tab-' . $tab . '.php';
        if (file_exists($file)) {
            require_once $file;
            $register_func = 'rewaardsc_register_settings_' . $tab;
            if (function_exists($register_func)) {
                $register_func();
            }
        }
    }
});

// Affiche la page HTML avec onglets et inclut le bon fichier d’onglet
function rewaardsc_render_settings_page()
{
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Vous n\'avez pas les permissions nécessaires pour accéder à cette page.', 'reewards'));
    }

    $active_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'general';// phpcs:ignore WordPress.Security.NonceVerification.Recommended
    ?>
    <div class="wrap">
        <h2 class="nav-tab-wrapper">
            <a href="?page=rewaardsc-settings&tab=general" class="nav-tab <?php echo $active_tab === 'general' ? 'nav-tab-active' : ''; ?>">
                ⚙️ <?php echo esc_html__('Général', 'reewards'); ?>
            </a>
            <a href="?page=rewaardsc-settings&tab=design" class="nav-tab <?php echo $active_tab === 'design' ? 'nav-tab-active' : ''; ?>">
                🧹 <?php echo esc_html__('Design', 'reewards'); ?>
            </a>
            <a href="?page=rewaardsc-settings&tab=emails" class="nav-tab <?php echo $active_tab === 'emails' ? 'nav-tab-active' : ''; ?>">
                📪 <?php echo esc_html__('Emails', 'reewards'); ?>
            </a>
            <a href="?page=rewaardsc-settings&tab=pro" class="nav-tab pro-tab <?php echo $active_tab === 'pro' ? 'nav-tab-active' : ''; ?>">
                ⭐ <?php echo esc_html__('PRO', 'reewards'); ?>
            </a>
        </h2>
        <?php
        // Inclut le bon fichier d’onglet (qui affiche le formulaire)
        $tab_file = __DIR__ . '/tab-' . $active_tab . '.php';
        $render_func = 'rewaardsc_render_tab_' . $active_tab;
        if (file_exists($tab_file) && function_exists($render_func)) {
            $render_func();
        } else {
            echo '<p>' . esc_html__('Onglet introuvable.', 'reewards') . '</p>';
        }
        ?>
    </div>
    <?php
    // Ajout du CSS en ligne
    wp_add_inline_style('reewards-admin', '
        .nav-tab.pro-tab {
            background: linear-gradient(90deg, #ffe259 0%, #ffa751 100%);
            color: #fff !important;
            font-weight: bold;
            border-color: #ffa751 #ffe259 #ffe259 #ffa751;
            box-shadow: 0 2px 16px 0 rgba(255, 174, 51, 0.18);
            position: relative;
            z-index: 10;
            overflow: hidden;
            transition: box-shadow 0.3s, background 0.3s, transform 0.2s;
        }
        .nav-tab.pro-tab.nav-tab-active {
            background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
            color: #fff !important;
            border-bottom: 3px solid #ff9800;
            box-shadow: 0 6px 24px 0 rgba(255, 174, 51, 0.28);
            transform: scale(1.04);
        }
    ');
}