<?php
// Protection contre l'accès direct
defined('ABSPATH') || exit;

use function Reewards\Utils\reewards_pro_field;

// Enregistrement des réglages de l’onglet Design
function rewaardsc_register_settings_design() {
    $is_pro = \Reewards\Utils\License::isProUser();
    $has_plugin_pro = function_exists('rewaardsc_pro_export_pdf');

    register_setting('rewaardsc_design_group', 'rewaardsc_theme_color', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_hex_color',
        'default'           => '#0170B9',
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_text_color', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_hex_color',
        'default'           => '#ffffff',
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_countdown_bg_color', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_hex_color',
        'default'           => '#222222',
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_countdown_text_color', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_hex_color',
        'default'           => '#ffffff',
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_censor_winners', [
        'type'              => 'boolean',
        'sanitize_callback' => 'rest_sanitize_boolean',
        'default'           => false,
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_theme_emoji', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => '🎁',
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_theme_emoji_densite', [
        'type'              => 'integer',
        'sanitize_callback' => 'absint',
        'default'           => 15,
    ]);

    register_setting('rewaardsc_design_group', 'rewaardsc_show_participants_count', [
        'type'              => 'boolean',
        'sanitize_callback' => 'rest_sanitize_boolean',
        'default'           => false,
    ]);

    add_settings_section(
        'rewaardsc_design_section',
        esc_html__('Paramètres de design', 'reewards'),
        '__return_false',
        'rewaardsc_design'
    );

    add_settings_field(
        'rewaardsc_theme_color',
        esc_html__('Couleur principale', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_theme_color', '#0170B9'));
            echo '<input type="text" class="wp-color-picker-field" name="rewaardsc_theme_color" value="' . esc_attr($value) . '" data-default-color="#0170B9" />';
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    add_settings_field(
        'rewaardsc_text_color',
        esc_html__('Couleur du texte', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_text_color', '#ffffff'));
            echo '<input type="text" class="wp-color-picker-field" name="rewaardsc_text_color" value="' . esc_attr($value) . '" data-default-color="#ffffff" />';
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    add_settings_field(
        'rewaardsc_countdown_bg_color',
        esc_html__('Couleur de fond du compte à rebours', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_countdown_bg_color', '#222222'));
            echo '<input type="text" class="wp-color-picker-field" name="rewaardsc_countdown_bg_color" value="' . esc_attr($value) . '" data-default-color="#222222" />';
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    add_settings_field(
        'rewaardsc_countdown_text_color',
        esc_html__('Couleur du texte du compte à rebours', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_countdown_text_color', '#ffffff'));
            echo '<input type="text" class="wp-color-picker-field" name="rewaardsc_countdown_text_color" value="' . esc_attr($value) . '" data-default-color="#ffffff" />';
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    add_settings_field(
        'rewaardsc_theme_emoji',
        esc_html__('Emoji', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_theme_emoji', '🎁'));
            $emojis = [
                ' ' => '---',
                '🎁' => '🎁',
                '🏆' => '🏆',
                '⭐' => '⭐',
                '🥇' => '🥇',
                '🏅' => '🏅',
                '💎' => '💎',
                '💰' => '💰',
                '🎯' => '🎯',
                '👑' => '👑',
                '🤩' => '🤩',
                '🎵' => '🎵',
                '🕹️' => '🕹️',
                '🪄' => '🪄',
                '🎉' => '🎉',
                '🎈' => '🎈',
                '🪅' => '🪅',
                '💌' => '💌',
                '🛍️' => '🛍️',
                '🎃' => '🎃',
                '👻' => '👻',
                '🕷️' => '🕷️',
                '🧙‍♀️' => '🧙‍♀️',
                '🕸️' => '🕸️',
                '🦇' => '🦇',
                '🍬' => '🍬',
                '🎄' => '🎄',
                '🎅' => '🎅',
                '⛄' => '⛄',
                '❄️' => '❄️',
                '🦌' => '🦌',
                '🥂' => '🥂',
                '🎆' => '🎆',
                '💖' => '💖',
                '💑' => '💑',
                '💍' => '💍',
                '🌸' => '🌸',
                '🐣' => '🐣',
                '🐰' => '🐰',
                '🥚' => '🥚',
                '🌷' => '🌷',
                '🐇' => '🐇',
                '🌞' => '🌞',
                '🏖️' => '🏖️',
                '🏝️' => '🏝️',
                '🍉' => '🍉',
                '🍦' => '🍦',
                '🍹' => '🍹',
                '🕶️' => '🕶️',
                '🍁' => '🍁',
                '🍂' => '🍂',
                '🌰' => '🌰',
                '☃️' => '☃️',
                '🧤' => '🧤',
                '🧣' => '🧣',
                '🔥' => '🔥',
                '⚡' => '⚡',
                '🚀' => '🚀',
                '💫' => '💫',
                '🪐' => '🪐',
                '🤖' => '🤖',
            ];
            echo '<select style="font-size: 150%" name="rewaardsc_theme_emoji">';
            foreach ($emojis as $emoji_char => $emoji_name) {
                echo '<option value="' . esc_attr($emoji_char) . '" ' . selected($value, $emoji_char, false) . '>' . esc_html($emoji_name) . '</option>';
            }
            echo '</select>';
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );


    $is_pro = \Reewards\Utils\License::isProUser();
    add_settings_field(
        'rewaardsc_censor_winners',
        esc_html__( 'Censurer le nom des gagnants (avec des étoiles)', 'reewards' ),
        function() use ($is_pro,$has_plugin_pro) {
            reewards_pro_field(
                'checkbox',
                [
                    'name' => 'rewaardsc_censor_winners',
                    'value' => 1,
                    'checked' => get_option('rewaardsc_censor_winners', false),
                ],
                'censor_winners',
                $is_pro,
                $has_plugin_pro
            );
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    
    add_settings_field(
        'rewaardsc_show_participants_count',
        esc_html__( 'Afficher le nombre de participants', 'reewards' ),
        function() use ($is_pro,$has_plugin_pro) {
            reewards_pro_field(
                'checkbox',
                [
                    'name' => 'rewaardsc_show_participants_count',
                    'value' => 1,
                    'checked' => get_option('rewaardsc_show_participants_count', true),
                ],
                'show_participants_count',
                $is_pro,
                $has_plugin_pro
            );
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );

    
    add_settings_field(
        'rewaardsc_theme_emoji_densite',
        esc_html__( 'Densité de l\'emoji', 'reewards' ),
        function() use ($is_pro,$has_plugin_pro) {
            reewards_pro_field(
                'range',
                [
                    'name' => 'rewaardsc_theme_emoji_densite',
                    'value' => get_option('rewaardsc_theme_emoji_densite', 11),
                    'min' => 0,
                    'max' => 100,
                ],
                'emoji_density',
                $is_pro,
                $has_plugin_pro
            );
        },
        'rewaardsc_design',
        'rewaardsc_design_section'
    );
}

// Affichage du formulaire de l’onglet Design
function rewaardsc_render_tab_design() {
    wp_enqueue_script('wp-color-picker');
    wp_enqueue_style('wp-color-picker');
    ?>
    <form method="post" action="options.php">
        <?php
        settings_fields('rewaardsc_design_group');
        do_settings_sections('rewaardsc_design');
        submit_button();
        ?>
    </form>

    <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e("Prévisualisation", 'reewards'); ?></h2>
    <div class="rewaardsc-preview-container">
        <div class="rewaardsc-preview-box rewaardsc-animate-card">
            <?php echo do_shortcode('[reewards_participate]'); ?>
        </div>
        <div class="rewaardsc-preview-box rewaardsc-animate-card">
            <?php echo do_shortcode('[reewards_history]'); ?>
        </div>
    </div>
    <style>
        .rewaardsc-preview-container {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-top: 30px;
        }
        .rewaardsc-preview-box {
            flex: 1 1 300px;
            border: 1px solid #ddd;
            padding: 15px;
            background: #fff;
            box-sizing: border-box;
            max-width: 100%;
            overflow-x: auto;
        }
        .rewaardsc-preview-box h3 {
            margin-top: 0;
            font-size: 16px;
        }
        @media (max-width: 600px) {
            .rewaardsc-preview-box {
                flex: 1 1 100%;
            }
            .rewaardsc-preview-box form,
            .rewaardsc-preview-box table,
            .rewaardsc-preview-box input,
            .rewaardsc-preview-box button {
                max-width: 100%;
                width: 100%;
                box-sizing: border-box;
            }
        }
    </style>
    <script>
    window.rewaardscProMessages = {
        censor_winners: "<?php echo esc_js(__('La censure des noms des gagnants est réservée aux utilisateurs PRO.', 'reewards')); ?>",
        show_participants_count: "<?php echo esc_js(__('L\'affichage du nombre de participants est réservé aux utilisateurs PRO.', 'reewards')); ?>",
        emoji_density: "<?php echo esc_js(__('La modification de la densité de l\'emoji est réservée aux utilisateurs PRO.', 'reewards')); ?>",
        pro_missing: "<?php echo esc_js(__('Votre licence PRO est valide, mais le plugin PRO n\'est pas installé ou activé. Veuillez installer le plugin PRO pour accéder à cette fonctionnalité.', 'reewards')); ?>"
    };
    </script>
    <script>
    jQuery(document).ready(function($){
        $('.wp-color-picker-field').wpColorPicker();
    });

    jQuery(document).on('focus click mousedown', '.rewaardsc-pro-field', function(e){
        if (typeof window.rewaardscProCheck === 'function') {
            var feature = jQuery(this).data('feature');
            var msg = window.rewaardscProMessages[feature] || window.rewaardscProMessages['pro_missing'];
            window.rewaardscProCheck(false, msg);
            jQuery(this).blur();
            e.preventDefault();
            return false;
        }
    });

    // Pour touchstart, ajoute passive: false
    document.querySelectorAll('.rewaardsc-pro-field').forEach(function(el) {
        el.addEventListener('touchstart', function(e) {
            if (typeof window.rewaardscProCheck === 'function') {
                var feature = this.dataset.feature;
                var msg = window.rewaardscProMessages[feature] || window.rewaardscProMessages['pro_missing'];
                window.rewaardscProCheck(false, msg);
                this.blur();
                e.preventDefault();
                return false;
            }
        }, { passive: false });
    });
    jQuery(document).on('keydown', '.rewaardsc-pro-field', function(e){
        e.preventDefault();
        return false;
    });

    jQuery(document).on('input change', 'input[name="rewaardsc_theme_emoji_densite"]', function() {
        jQuery(this).next('#emoji-density-value').text(this.value);
    });
    </script>
    <?php
}