<?php
// Prevent direct access to the file
defined('ABSPATH') || exit;

use Reewards\Domain\TirageService;

function rewaardsc_register_settings_emails() {
    register_setting('rewaardsc_emails_group', 'rewaardsc_email_subject', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => __('Notification de concours', 'reewards'),
    ]);

    register_setting(
        'rewaardsc_emails_group',
        'rewaardsc_emails_templates',
        [
            'type' => 'array',
            'sanitize_callback' => function ($input) {
                foreach (['admin', 'winner', 'loser'] as $type) {
                    $input[$type]['active'] = !empty($input[$type]['active']) ? 1 : 0;
                    $input[$type]['title'] = sanitize_text_field($input[$type]['title'] ?? '');
                    $input[$type]['content'] = wp_kses_post($input[$type]['content'] ?? '');
                }
                return $input;
            },
            'default' => [
                'admin'  => ['active' => 1, 'title' => __('Notification admin', 'reewards'), 'content' => ''],
                'winner' => ['active' => 1, 'title' => __('Bravo {username} !', 'reewards'), 'content' => ''],
                'loser'  => ['active' => 0, 'title' => __('Merci pour votre participation', 'reewards'), 'content' => ''],
            ],
        ]
    );
}

function rewaardsc_render_tab_emails() {
    $is_pro = \Reewards\Utils\License::isProUser();

    if (isset($_POST['rewaardsc_send_test']) && !empty($_POST['rewaardsc_test_email'])) {
        check_admin_referer('rewaardsc_send_test_action', 'rewaardsc_send_test_nonce');

        $test_email = isset($_POST['rewaardsc_test_email'])
        ? sanitize_email( wp_unslash( $_POST['rewaardsc_test_email'] ) )
        : '';
        if (!is_email($test_email)) {
            $result = 'error';
            $message = esc_html__('Adresse email invalide.', 'reewards') . "\n" . esc_html__('Vérifiez l\'adresse email.\nVérifiez votre configuration SMTP (nous vous conseillons le plugin WP Mail SMTP)', 'reewards');
        } else {
            add_filter('wp_mail_from', function ($from) {
                return get_option('admin_email');
            });
            add_filter('wp_mail_from_name', function ($name) {
                return get_bloginfo('name');
            });

            $subject = esc_html__('REEWARDS - Test email', 'reewards');
            $body = esc_html__('Ceci est un test d\'envoi d\'email depuis le plugin REEWARDS.', 'reewards');
            $headers = ['Content-Type: text/html; charset=UTF-8'];
            $sent = wp_mail($test_email, $subject, $body, $headers);

            if ($sent) {
                TirageService::log(esc_html__('Email de test envoyé à ', 'reewards') . $test_email);
                $result = 'success';
                $message = esc_html__('Email de test envoyé avec succès à ', 'reewards') . $test_email . ". ";
                $message .= esc_html__('Vous n\'avez pas reçu l\'email ? Vérifiez votre configuration SMTP (nous vous conseillons le plugin WP Mail SMTP)', 'reewards');
            } else {
                $result = 'error';
                $message = esc_html__('Erreur lors de l\'envoi de l\'email à ', 'reewards') . $test_email . ".\n";
                $message .= esc_html__('Vérifiez l\'adresse email.\nVérifiez votre configuration SMTP (nous vous conseillons le plugin WP Mail SMTP)', 'reewards');
            }
        }

        $redirect_url = add_query_arg([
            'page' => 'rewaardsc-settings',
            'tab' => 'emails',
            'rewaardsc_test_result' => $result,
            'rewaardsc_test_message' => urlencode($message),
        ], admin_url('admin.php'));
        wp_redirect($redirect_url);
        exit;
    }

    ?>
    <div class="rewaardsc-email-test">
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e("Test d'envoi d'email", 'reewards'); ?></h2>
        <p><?php esc_html_e('Entrez une adresse email pour tester l\'envoi.', 'reewards'); ?></p>
        <form method="post">
            <?php wp_nonce_field('rewaardsc_send_test_action', 'rewaardsc_send_test_nonce'); ?>
            <input type="email" name="rewaardsc_test_email" placeholder="example@gmail.com" style="width:300px;max-width:100%;" required />
            <?php submit_button(esc_html__('Envoyer un email de test', 'reewards'), 'primary', 'rewaardsc_send_test', false); ?>
        </form>
        <?php if (isset($_GET['rewaardsc_test_result'])): ?>
            <?php
            $msg = isset($_GET['rewaardsc_test_message']) ? sanitize_text_field(wp_unslash($_GET['rewaardsc_test_message'])) : '';
            ?>
            <?php if ($_GET['rewaardsc_test_result'] === 'success'): ?>
                <div class="notice notice-success" style="margin-top:10px;"><p><?php echo esc_html($msg); ?></p></div>
            <?php else: ?>
                <div class="notice notice-error" style="margin-top:10px;"><p><?php echo esc_html($msg); ?></p></div>
            <?php endif; ?>
        <?php endif; ?>
    </div>

                <hr>
                
                <form method="post" action="options.php">
                <?php
                settings_fields( 'rewaardsc_emails_group' );
                do_settings_sections( 'rewaardsc_emails' );
                ?>
                <!-- ✅ Modification des mails -->
                 <input type="hidden" name="rewaardsc_emails_templates[admin][active]" id="rewaardsc_emails_admin_active" value="1" />
                <input type="hidden" name="rewaardsc_emails_templates[admin][title]" id="rewaardsc_emails_admin_title" value="" />
                <input type="hidden" name="rewaardsc_emails_templates[admin][content]" id="rewaardsc_emails_admin_content" value="" />

                <input type="hidden" name="rewaardsc_emails_templates[winner][active]" id="rewaardsc_emails_winner_active" value="1" />
                <input type="hidden" name="rewaardsc_emails_templates[winner][title]" id="rewaardsc_emails_winner_title" value="" />
                <input type="hidden" name="rewaardsc_emails_templates[winner][content]" id="rewaardsc_emails_winner_content" value="" />

                <input type="hidden" name="rewaardsc_emails_templates[loser][active]" id="rewaardsc_emails_loser_active" value="1" />
                <input type="hidden" name="rewaardsc_emails_templates[loser][title]" id="rewaardsc_emails_loser_title" value="" />
                <input type="hidden" name="rewaardsc_emails_templates[loser][content]" id="rewaardsc_emails_loser_content" value="" />
                <div class="wrap">
                    <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e("Personnalisation des emails", 'reewards'); ?></h2>


                    <div class="rewaardsc-email-container" style="display:flex; gap:20px; align-items:flex-start;">
                        
                        <!-- Colonne 1 : Liste des emails -->
                        <div class="rewaardsc-email-list rewaardsc-animate-card" style="flex:1;">
                            <h3><?php esc_html_e('Choisir un email', 'reewards'); ?></h3>
                            <div class="rewaardsc-email-card" data-template="admin">
                                <strong><?php esc_html_e('Email administrateur', 'reewards'); ?></strong>
                            </div>
                            <div class="rewaardsc-email-card" data-template="winner">
                                <strong><?php esc_html_e('Email gagnants', 'reewards'); ?></strong>
                            </div>
                            <div class="rewaardsc-email-card<?php echo !$is_pro ? ' disabled' : ''; ?>" data-template="loser">
                                <strong><?php esc_html_e('Email perdants', 'reewards'); ?></strong>
                            </div>
                        </div>

                        <!-- Colonne 2 : Éditeur -->
                        <div class="rewaardsc-email-editor-box rewaardsc-animate-card" style="flex:2;">
                            <h3 id="rewaardsc-email-title"><?php esc_html_e('Sélectionnez un email à modifier', 'reewards'); ?></h3>
                            
                            <!-- Switch activation -->
                            <div id="rewaardsc-email-active-toggle" style="margin:10px 0; display:none;">
                                <label class="rewaardsc-switch">
                                    <input type="checkbox" id="rewaardsc-email-active">
                                    <span class="rewaardsc-slider"></span>
                                </label>
                                <span id="rewaardsc-email-active-label" style="margin-left:10px;"></span>
                            </div>

                            <label for="rewaardsc-email-title-input">Titre du mail :</label>
                            <input type="text" id="rewaardsc-email-title-input" style="width: 100%; margin-bottom: 10px;">

                            <div class="rewaardsc-email-dynamic-buttons">
                                <button type="button" class="rewaardsc-email-dynamic-btn" data-tag="{username}">{username}</button>
                                <button type="button" class="rewaardsc-email-dynamic-btn" data-tag="{email}">{email}</button>
                            </div>


                            <?php 
                            wp_editor(
                                '', 
                                'rewaardsc_email_editor',
                                [
                                    'textarea_name' => 'rewaardsc_email_editor',
                                    'textarea_rows' => 14,
                                    'media_buttons' => false,
                                    'teeny' => true,
                                    'tinymce' => [
                                        'toolbar1' => 'formatselect bold italic underline forecolor backcolor bullist numlist link unlink removeformat',
                                        'toolbar2' => 'fontsizeselect fontselect alignleft aligncenter alignright outdent indent',
                                        'plugins'  => 'lists textcolor colorpicker link',
                                    ],
                                    'media_buttons' => true,
                                ]
                            );
                            ?>
                        </div>

                        <!-- Colonne 3 : Prévisualisation -->
                        <div class="rewaardsc-email-preview-box rewaardsc-animate-card" style="flex:2;">
                            <h3><?php esc_html_e('Prévisualisation', 'reewards'); ?></h3>
                            <div class="rewaardsc-email-preview-wrapper">
                                <div class="rewaardsc-email-preview-header" id="rewaardsc-email-preview-title"></div>
                                <div class="rewaardsc-email-preview-body" id="rewaardsc-email-preview-content"></div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php echo esc_html(submit_button()); ?>
            </form>
    <style>
                    .rewaardsc-email-card.disabled {
                        opacity: 0.6;
                        filter: grayscale(1);
                    }
                    .rewaardsc-email-container {
                        display: flex;
                        gap: 20px;
                        flex-wrap: wrap;
                        margin-top: 20px;
                    }
                    .rewaardsc-email-box {
                        flex: 1 1 300px;
                        border: 1px solid #ddd;
                        padding: 15px;
                        background: #fff;
                        box-sizing: border-box;
                        min-width: 280px;
                    }
                    @media(max-width: 768px) {
                        .rewaardsc-email-box {
                            flex: 1 1 100%;
                        }
                    }

                    .rewaardsc-email-list {
                        display: flex;
                        flex-direction: column;
                        gap: 15px;
                    }

                    .rewaardsc-email-card {
                        padding: 15px;
                        border: 1px solid #ddd;
                        border-radius: 10px;
                        background: #f9f9f9;
                        cursor: pointer;
                        transition: all 0.2s ease-in-out;
                    }

                    .rewaardsc-email-card:hover {
                        background: #eef6ff;
                        border-color: #0073aa;
                    }

                    .rewaardsc-email-card.active {
                        background: #dceeff;
                        border-color: #0073aa;
                        box-shadow: 0 0 5px rgba(0,115,170,0.3);
                    }

                    /* Switch toggle */
                    .rewaardsc-switch {
                        position: relative;
                        display: inline-block;
                        width: 45px;
                        height: 22px;
                    }

                    .rewaardsc-switch input { display:none; }

                    .rewaardsc-slider {
                        position: absolute;
                        cursor: pointer;
                        top: 0; left: 0; right: 0; bottom: 0;
                        background-color: #ccc;
                        transition: .4s;
                        border-radius: 22px;
                    }

                    .rewaardsc-slider:before {
                        position: absolute;
                        content: "";
                        height: 18px; width: 18px;
                        left: 2px; bottom: 2px;
                        background-color: white;
                        transition: .4s;
                        border-radius: 50%;
                    }

                    .rewaardsc-switch input:checked + .rewaardsc-slider {
                        background-color: #32a852;
                    }

                    .rewaardsc-switch input:checked + .rewaardsc-slider:before {
                        transform: translateX(23px);
                    }


                    .rewaardsc-email-preview-wrapper {
                        max-width: 480px;
                        margin: 24px auto 0 auto;
                        background: #f4f4f4;
                        border-radius: 8px;
                        box-shadow: 0 2px 12px rgba(0,0,0,0.07);
                        overflow: hidden;
                        font-family: 'Segoe UI', Arial, sans-serif;
                        border: 1px solid #e0e0e0;
                    }

                    .rewaardsc-email-preview-header {
                        background: #0170B9;
                        color: #fff;
                        padding: 18px 24px;
                        font-size: 1.2em;
                        font-weight: 600;
                        letter-spacing: 0.5px;
                    }

                    .rewaardsc-email-preview-body {
                        background: #fff;
                        padding: 24px;
                        font-size: 1em;
                        color: #222;
                        line-height: 1.7;
                        min-height: 80px;
                        word-break: break-word;
                    }

                    @media (max-width: 600px) {
                        .rewaardsc-email-preview-wrapper {
                            max-width: 98vw;
                            margin: 16px 1vw 0 1vw;
                        }
                        .rewaardsc-email-preview-header,
                        .rewaardsc-email-preview-body {
                            padding-left: 12px;
                            padding-right: 12px;
                        }
                    }

                    .rewaardsc-email-dynamic-btn{
                        margin-top: 10px;
                        margin-bottom: 10px;
                    }

                </style>

                
                <script>
                    window.rewaardsc_is_pro = <?php echo $is_pro ? 'true' : 'false'; ?>;
                </script>
                
                
                <script>
                window.rewaardscEmailsI18n = {
                    mailTitle: "<?php echo esc_js(__('Titre du mail', 'reewards')); ?>",
                    noContent: "<?php echo esc_js(__('Aucun contenu pour ce mail', 'reewards')); ?>",
                    noMail: "<?php echo esc_js(__('Aucun mail sélectionné', 'reewards')); ?>",
                    selectMail: "<?php echo esc_js(__('Sélectionnez un mail pour prévisualiser son contenu', 'reewards')); ?>",
                    enabled: "<?php echo esc_js(__('Email activé', 'reewards')); ?>",
                    disabled: "<?php echo esc_js(__('Email désactivé', 'reewards')); ?>",
                    proOnly: "<?php echo esc_js(__('La modification de l\'email perdants est réservée aux utilisateurs PRO.', 'reewards')); ?>"
                };
                </script>
                <script>
                window.RewaardscUser = {
                    username: "<?php echo esc_js(wp_get_current_user()->display_name ?: 'Utilisateur'); ?>",
                    email: "<?php echo esc_js(wp_get_current_user()->user_email ?: 'email@example.com'); ?>"
                };
                </script>
                <script>
                jQuery(document).ready(function($){
                    // ✅ Live preview de l'éditeur
                    $(document).on('input', '#rewaardsc_email_editor', function(){
                        $('#rewaardsc_email_preview').html($(this).val());
                    });
                });

                jQuery(document).ready(function($) {

                    const emailTemplates = <?php echo json_encode(get_option('rewaardsc_emails_templates')); ?>;

                    // Initialise les data() sur chaque carte
                    $('.rewaardsc-email-card').each(function() {
                        let type = $(this).data('template');
                        if(emailTemplates && emailTemplates[type]) {
                            $(this).data('title', emailTemplates[type].title);
                            $(this).data('content', emailTemplates[type].content);
                            $(this).data('active', !!parseInt(emailTemplates[type].active));
                        } else {
                            $(this).data('title', '');
                            $(this).data('content', '');
                            $(this).data('active', true);
                        }
                    });
                    ['admin','winner','loser'].forEach(function(type){
                        saveCurrentEmailToHiddenFields(type);
                    });
                    $('.rewaardsc-email-card[data-template="admin"]').trigger('click');

                    $('form').on('submit', function() {
                        ['admin','winner','loser'].forEach(function(type){
                            saveCurrentEmailToHiddenFields(type);
                        });
                    });

                    function saveCurrentEmailToHiddenFields(type) {
                        $('#rewaardsc_emails_' + type + '_active').val($('.rewaardsc-email-card[data-template="'+type+'"]').data('active') ? 1 : 0);
                        $('#rewaardsc_emails_' + type + '_title').val($('.rewaardsc-email-card[data-template="'+type+'"]').data('title') || '');
                        $('#rewaardsc_emails_' + type + '_content').val($('.rewaardsc-email-card[data-template="'+type+'"]').data('content') || '');
                    }

                    const exampleData = {
                        username: RewaardscUser.username || 'Utilisateur',
                        email: RewaardscUser.email || 'email@example.com'
                    };

                    function renderContent(content, title) {
                        // Remplacer les balises dynamiques pour la prévisualisation
                        if (content) {
                            content = content.replace(/{username}/g, exampleData.username)
                                            .replace(/{email}/g, exampleData.email);
                        }
                        if (title) {
                            title = title.replace(/{username}/g, exampleData.username)
                                        .replace(/{email}/g, exampleData.email);
                        }
                        return { content, title };
                    }

                    function updatePreview(content, title) {
                        const rendered = renderContent(content, title);
                        $('#rewaardsc-email-preview-title').text(rendered.title || window.rewaardscEmailsI18n.mailTitle);
                        $('#rewaardsc-email-preview-content').html(rendered.content || '<em>' + window.rewaardscEmailsI18n.noContent + '</em>');

                        const activeCard = $('.rewaardsc-email-card.active');
                        if (activeCard.length) {
                            activeCard.data('content', content);
                            activeCard.data('title', title);
                        }
                    }

                    function setFieldsDisabled(state) {
                        $('#rewaardsc-email-title-input').prop('disabled', state);
                        $('.rewaardsc-email-dynamic-btn').prop('disabled', state);
                        $('#insert-media-button').prop('disabled',state);
                        if (typeof tinyMCE !== "undefined" && tinyMCE.get('rewaardsc_email_editor')) {
                            tinyMCE.get('rewaardsc_email_editor').setMode(state ? 'readonly' : 'design');
                        } else {
                            $('#rewaardsc_email_editor').prop('disabled', state);
                        }
                        // Prévisualisation grisée si désactivée
                        if(state){
                            $('#rewaardsc-email-preview-title').text(window.rewaardscEmailsI18n.noMail);
                            $('#rewaardsc-email-preview').html('<em>' + window.rewaardscEmailsI18n.selectMail + '</em>');
                        }
                    }

                    // --- Initialisation par défaut ---
                    setFieldsDisabled(true);
                    $('#rewaardsc-email-active-toggle').hide();

                    // --- Sélection d'un email ---
                    $('.rewaardsc-email-card').on('click', function(e) {

                        let type = $(this).data('template');
                        if(type === 'loser' && !window.rewaardscProCheck(window.rewaardsc_is_pro, window.rewaardscEmailsI18n.proOnly)) {
                            e.preventDefault();
                            return false;
                        }

                        $('.rewaardsc-email-card').removeClass('active');
                        $(this).addClass('active');

                        let title = $(this).data('title') || $(this).find('strong').text();
                        let content = $(this).data('content') || '';
                        let isActive = $(this).data('active') === true;

                        saveCurrentEmailToHiddenFields(type);

                        // Activer les champs
                        setFieldsDisabled(false);

                        // Mettre à jour le champ titre
                        $('#rewaardsc-email-title-input').val(title);

                        // Afficher le toggle
                        $('#rewaardsc-email-active-toggle').show();
                        $('#rewaardsc-email-active').prop('checked', isActive);
                        $('#rewaardsc-email-active-label').text(isActive ? window.rewaardscEmailsI18n.enabled : window.rewaardscEmailsI18n.disabled);

                        if (typeof tinyMCE !== "undefined" && tinyMCE.get('rewaardsc_email_editor')) {
                            tinyMCE.get('rewaardsc_email_editor').setContent(content);
                            tinyMCE.get('rewaardsc_email_editor').off('keyup input');
                            tinyMCE.get('rewaardsc_email_editor').on('keyup input', function(e) {
                                updatePreview(this.getContent(), $('#rewaardsc-email-title-input').val());
                            });
                        }

                        $('#rewaardsc_email_editor').val(content);
                        updatePreview(content, title);
                    });

                    // --- Switch activé/désactivé ---
                    $('#rewaardsc-email-active').on('change', function() {
                        let isActive = $(this).is(':checked');
                        $('#rewaardsc-email-active-label').text(isActive ? window.rewaardscEmailsI18n.enabled : window.rewaardscEmailsI18n.disabled);
                        $('.rewaardsc-email-card.active').data('active', isActive);
                    });

                    // --- Mise à jour live du titre ---
                    $('#rewaardsc-email-title-input').on('input', function() {
                        let type = $('.rewaardsc-email-card.active').data('template');

                        let title = $(this).val();
                        let content = typeof tinyMCE !== "undefined" && tinyMCE.get('rewaardsc_email_editor') 
                            ? tinyMCE.get('rewaardsc_email_editor').getContent()
                            : $('#rewaardsc_email_editor').val();

                        $('.rewaardsc-email-card.active').data('title', title);
                        updatePreview(content, title);

                        saveCurrentEmailToHiddenFields(type);
                    });

                    // --- Mode textarea ---
                    $('#rewaardsc_email_editor').on('input', function() {
                        let type = $('.rewaardsc-email-card.active').data('template');
                        let content = $(this).val();
                        let title = $('#rewaardsc-email-title-input').val();

                        // Met à jour les données de la carte active
                        $('.rewaardsc-email-card.active').data('content', content);

                        saveCurrentEmailToHiddenFields(type);
                        updatePreview(content, title);
                    });

                    // --- Boutons pour insérer les balises dynamiques ---
                    $('.rewaardsc-email-dynamic-btn').on('click', function(e) {
                        e.preventDefault();
                        let tag = $(this).data('tag');
                        let titleInput = $('#rewaardsc-email-title-input');

                        // Si le titre a le focus, insérer dans le titre
                        if (titleInput.is(':focus')) {
                            let pos = titleInput.prop('selectionStart');
                            let val = titleInput.val();
                            titleInput.val(val.substring(0, pos) + tag + val.substring(pos));
                            titleInput[0].selectionStart = titleInput[0].selectionEnd = pos + tag.length;
                            titleInput.trigger('input');
                            return;
                        }

                        // Sinon, insérer dans le contenu (TinyMCE ou textarea)
                        if (typeof tinyMCE !== "undefined" && tinyMCE.get('rewaardsc_email_editor') && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) {
                            tinyMCE.activeEditor.execCommand('mceInsertContent', false, tag);
                            tinyMCE.activeEditor.focus();
                        } else {
                            let textarea = $('#rewaardsc_email_editor');
                            let start = textarea.prop('selectionStart');
                            let end = textarea.prop('selectionEnd');
                            let val = textarea.val();
                            textarea.val(val.substring(0, start) + tag + val.substring(end));
                            textarea[0].selectionStart = textarea[0].selectionEnd = start + tag.length;
                            textarea.focus();
                            textarea.trigger('input');
                        }
                    });

                });
                </script>
    <?php



}