<?php
// Empêcher l'accès direct au fichier
defined('ABSPATH') || exit;

// Enregistrement des réglages (à faire dans un hook admin_init dans ce fichier ou dans un fichier commun)
if (isset($_GET['settings-updated'])) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    echo '<div class="updated notice is-dismissible"><p>' . esc_html__('Réglages enregistrés.', 'reewards') . '</p></div>';
}

// Action AJAX pour la prévisualisation fidèle des formats de date/heure
add_action('wp_ajax_rewaardsc_format_example', function () {
    check_ajax_referer('rewaardsc_format_example_nonce', 'security');

    if (!current_user_can('manage_options')) {
        wp_send_json_error();
    }

    $format = isset($_POST['format']) ? sanitize_text_field(wp_unslash($_POST['format'])) : '';
    $timestamp = isset($_POST['timestamp']) ? absint($_POST['timestamp']) : current_time('timestamp');
    $formatted = date_i18n($format, $timestamp);
    wp_send_json_success(['formatted' => $formatted]);
});

// Enregistrement des réglages de l’onglet Général
function rewaardsc_register_settings_general() {
    register_setting('rewaardsc_general_group', 'rewaardsc_admin_email', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_email',
        'default'           => get_option('admin_email'),
    ]);
    register_setting('rewaardsc_general_group', 'rewaardsc_plugin_language', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => 'en_US',
    ]);

    register_setting('rewaardsc_general_group', 'rewaardsc_date_format', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => get_option('date_format', 'd/m/Y'),
    ]);
    register_setting('rewaardsc_general_group', 'rewaardsc_time_format', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => get_option('time_format', 'H:i'),
    ]);
    register_setting('rewaardsc_general_group', 'rewaardsc_datetime_format', [
        'type'              => 'string',
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => get_option('date_format', 'd/m/Y') . ' ' . get_option('time_format', 'H:i'),
    ]);

    add_settings_section(
        'rewaardsc_general_section',
        esc_html__('Paramètres généraux', 'reewards'),
        '__return_false',
        'rewaardsc_general'
    );

    add_settings_field(
        'rewaardsc_plugin_language',
        esc_html__('Langue du plugin', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_plugin_language', get_locale()));
            $languages = [
                'fr_FR' => 'Français',
                'en_US' => 'English',
            ];
            echo '<select name="rewaardsc_plugin_language">';
            foreach ($languages as $code => $label) {
                echo '<option value="' . esc_attr($code) . '" ' . selected($value, $code, false) . '>' . esc_html($label) . '</option>';
            }
            echo '</select>';
        },
        'rewaardsc_general',
        'rewaardsc_general_section'
    );

    add_settings_field(
        'rewaardsc_admin_email',
        esc_html__('Email administrateur', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_admin_email', get_option('admin_email')));
            echo '<input type="email" name="rewaardsc_admin_email" value="' . esc_attr($value) . '" class="regular-text" />';
            echo '<p class="description">' . esc_html__('Adresse email utilisée pour recevoir les notifications et tirages au sort.', 'reewards') . '</p>';
        },
        'rewaardsc_general',
        'rewaardsc_general_section'
    );

    add_settings_field(
        'rewaardsc_date_format',
        esc_html__('Format de la date', 'reewards'),
        function () {
            $value = esc_attr(get_option('rewaardsc_date_format', get_option('date_format', 'd/m/Y')));
            $now = current_time('timestamp');
            $example = date_i18n($value, $now);
            $formats = [
                'd/m/Y H:i'         => date_i18n('d/m/Y H:i', $now),
                'm/d/Y H:i'         => date_i18n('m/d/Y H:i', $now),
                'Y-m-d H:i'         => date_i18n('Y-m-d H:i', $now),
                'd.m.Y H:i'         => date_i18n('d.m.Y H:i', $now),
                'd-m-Y H:i'         => date_i18n('d-m-Y H:i', $now),
                'j F Y H:i'         => date_i18n('j F Y H:i', $now),
                'l d F Y H:i'       => date_i18n('l d F Y H:i', $now),
                'D, d M Y H:i'      => date_i18n('D, d M Y H:i', $now),
                'l j F Y H:i'       => date_i18n('l j F Y H:i', $now),
            ];
            echo '<select id="rewaardsc_date_format" name="rewaardsc_date_format" class="regular-text">';
            foreach ($formats as $format => $preview) {
                echo '<option value="' . esc_attr($format) . '" ' . selected($value, $format, false) . '>' . esc_html($format . '  (' . $preview . ')') . '</option>';
            }
            echo '</select>';
            // translators: %s is replaced with a preview date example.
            echo '<p id="rewaardsc_date_example" data-template="' . esc_attr(__('Prévisualisation : <strong>%s</strong>', 'reewards')) . '" style="color:#666;font-size:13px;margin:4px 0 0;">' . sprintf(esc_html__('Prévisualisation : <strong>%s</strong>', 'reewards'), esc_html($example)) . '</p>';
        },
        'rewaardsc_general',
        'rewaardsc_general_section'
    );
}

// Affichage du formulaire de l’onglet Général
function rewaardsc_render_tab_general() {
    ?>
    <form method="post" action="options.php">
        <?php
        settings_fields('rewaardsc_general_group');
        do_settings_sections('rewaardsc_general');
        submit_button();
        ?>
    </form>

    <script>
        // S'assure que ajaxurl est défini (normalement déjà présent en admin WP)
        if (typeof ajaxurl === 'undefined') {
            var ajaxurl = "<?php echo esc_url(admin_url('admin-ajax.php')); ?>";
        }
        (function () {
            var now = <?php echo esc_js(current_time('timestamp')); ?>;
            function updateExample(idInput, idExample) {
                var input = document.getElementById(idInput);
                var example = document.getElementById(idExample);
                if (!input || !example) return;
                input.addEventListener('input', function () {
                    var format = input.value;
                    var template = example.getAttribute('data-template');
                    var xhr = new XMLHttpRequest();
                    xhr.open('POST', ajaxurl, true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
                    xhr.onload = function () {
                        if (xhr.status === 200) {
                            try {
                                var response = JSON.parse(xhr.responseText);
                                if (response.success && response.data && response.data.formatted) {
                                    example.innerHTML = template.replace('%s', response.data.formatted);
                                }
                            } catch (e) {}
                        }
                    };
                    xhr.send('action=rewaardsc_format_example&security=<?php echo esc_html(wp_create_nonce('rewaardsc_format_example_nonce')); ?>&format=' + encodeURIComponent(format) + '&timestamp=' + now);
                });
            }
            updateExample('rewaardsc_date_format', 'rewaardsc_date_example');
            updateExample('rewaardsc_time_format', 'rewaardsc_time_example');
            updateExample('rewaardsc_datetime_format', 'rewaardsc_datetime_example');
        })();
    </script>
    <?php
}