<?php
// Empêcher l'accès direct au fichier
defined('ABSPATH') || exit;

// Vérification de la licence
if (
    isset($_POST['rewaardsc_pro_license_submit']) &&
    check_admin_referer('rewaardsc_pro_license_action', 'rewaardsc_pro_license_nonce')
) {
    // Vérification des permissions utilisateur
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('Vous n’avez pas les permissions nécessaires pour effectuer cette action.', 'reewards'));
    }

    $key = isset($_POST['rewaardsc_pro_license_key'])
    ? sanitize_text_field( wp_unslash( $_POST['rewaardsc_pro_license_key'] ) )
    : '';
    update_option('rewaardsc_pro_license_key', $key);

    $response = wp_remote_post('https://mg-plugins.com/wp-json/mg-licences/v1/verify', [
        'headers' => ['Content-Type' => 'application/json'],
        'body'    => wp_json_encode([
            'licence_key' => $key,
            'site_url'    => preg_replace('#^https?://#', '', get_site_url()), // format www.site.com
            'plugin_id'   => '140',
        ]),
        'timeout' => 10,
    ]);

    if (is_wp_error($response)) {
        update_option('rewaardsc_pro_license_status', 'invalid');
        update_option('rewaardsc_pro_license_message', esc_html__('Erreur de connexion au serveur de licence.', 'reewards'));
        update_option('rewaardsc_pro_license_expiration', '');
    } else {
        $body = json_decode(wp_remote_retrieve_body($response), true);
        if (!empty($body['success'])) {
            update_option('rewaardsc_pro_license_status', 'valid');
            $expiration = !empty($body['expiration']) ? sanitize_text_field($body['expiration']) : '';
            update_option('rewaardsc_pro_license_expiration', $expiration);
            // Stocke la date d'expiration si présente (ex: 'expiration_date' => '2030-05-25')
            if (!empty($body['expiration_date'])) {
                update_option('rewaardsc_pro_license_expiration_date', sanitize_text_field($body['expiration_date']));
            } else {
                update_option('rewaardsc_pro_license_expiration_date', '');
            }
        } else {
            update_option('rewaardsc_pro_license_status', 'invalid');
            update_option('rewaardsc_pro_license_expiration', '');
            update_option('rewaardsc_pro_license_expiration_date', '');
        }
        // Stocke le message de l'API ou un message par défaut
        $api_message = !empty($body['message']) ? sanitize_text_field($body['message']) : esc_html__('Réponse du serveur reçue.', 'reewards');
        update_option('rewaardsc_pro_license_message', $api_message);
    }

    // Recharge la page pour éviter le resoumission du formulaire
    wp_redirect(add_query_arg(['page' => 'rewaardsc-settings', 'tab' => 'pro'], admin_url('admin.php')));
    exit;
}

function rewaardsc_render_tab_pro() {
    $license_key = esc_attr(get_option('rewaardsc_pro_license_key', ''));
    $license_status = esc_attr(get_option('rewaardsc_pro_license_status', 'inactive'));
    $license_message = esc_html(get_option('rewaardsc_pro_license_message', ''));
    $expiration = esc_html(get_option('rewaardsc_pro_license_expiration', ''));
    ?>
    <div class="rewaardsc-pro-flex-wrap">
    <div class="rewaardsc-pro-license-box rewaardsc-fade-in">
        <div class="rewaardsc-pro-license-header">
            <span class="dashicons dashicons-awards rewaardsc-rotate-in"></span>
            <h2><?php esc_html_e('Activation de licence PRO', 'reewards'); ?></h2>
            <p><?php esc_html_e('Débloquez toutes les fonctionnalités avancées du plugin en activant votre licence PRO.', 'reewards'); ?></p>
        </div>
        <form method="post" class="rewaardsc-pro-license-form">
            <?php wp_nonce_field('rewaardsc_pro_license_action', 'rewaardsc_pro_license_nonce'); ?>
            <input type="text" name="rewaardsc_pro_license_key" value="<?php echo esc_attr($license_key); ?>" placeholder="<?php esc_attr_e('Entrez votre clé de licence', 'reewards'); ?>" class="rewaardsc-pro-license-input" />
            <button type="submit" name="rewaardsc_pro_license_submit" class="button button-primary rewaardsc-pro-license-btn<?php echo ($license_status !== 'valid') ? ' rewaardsc-pulse' : ''; ?>"><?php esc_html_e('Vérifier la licence', 'reewards'); ?></button>
            <div class="rewaardsc-pro-license-status rewaardsc-fade-in">
                <?php if ($license_status === 'valid'): ?>
                    <span class="rewaardsc-pro-valid">✔️ <?php esc_html_e('Licence valide', 'reewards'); ?></span>
                    <?php if (!empty($expiration)): ?>
                        <?php // translators: %s is replaced with a preview date example. ?>
                        <div class="rewaardsc-pro-expiration rewaardsc-slide-in"><?php echo sprintf(esc_html__('Date d\'expiration : %s', 'reewards'), esc_html($expiration)); ?></div>
                    <?php endif; ?>
                <?php elseif ($license_status === 'invalid'): ?>
                    <span class="rewaardsc-pro-invalid">❌ <?php esc_html_e('Licence invalide', 'reewards'); ?></span>
                <?php endif; ?>
            </div>
        </form>
        <?php if ($license_status === 'valid'): ?>
            <div class="rewaardsc-pro-license-message rewaardsc-fade-in" style="color:#32a852;"><?php esc_html_e('Félicitations, votre licence est activée', 'reewards'); ?></div>
        <?php elseif (!empty($license_message)): ?>
            <div class="rewaardsc-pro-license-message rewaardsc-fade-in"><?php echo esc_html($license_message); ?></div>
        <?php endif; ?>
        <div class="rewaardsc-pro-license-help rewaardsc-fade-in">
            <span class="dashicons dashicons-cart"></span>
            <span>
            <?php esc_html_e('Envie de débloquer les fonctionnalités PRO ?', 'reewards'); ?>
            <a href="https://mg-plugins.com/plugin/reewards/" target="_blank" style="color:#ff9800;font-weight:bold;text-decoration:underline;">
                <?php esc_html_e('Acheter une licence', 'reewards'); ?>
            </a>
            </span>        
        </div>
    </div>
    <style>
        
    .rewaardsc-pro-license-box {
        max-width: 340px;
        margin: 32px auto 0 auto;
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 2px 16px rgba(255, 174, 51, 0.10);
        padding: 22px 18px 16px 18px;
        text-align: center;
        border: 1.5px solid #ffe259;
        font-family: 'Segoe UI', Arial, sans-serif;
        opacity: 0;
        animation: rewaardscFadeIn 0.7s 0.1s forwards, rewaardscCardGlow 2.2s 0.8s infinite;
        transition: box-shadow 0.3s;
        position: relative;
    }

    @keyframes rewaardscCardGlow {
        0% {
            box-shadow:
                0 2px 16px rgba(255, 174, 51, 0.10),
                0 0 0 0 #ffe25933;
        }
        50% {
            box-shadow:
                0 4px 32px rgba(255, 174, 51, 0.18),
                0 0 12px 4px #ffe25944;
        }
        100% {
            box-shadow:
                0 2px 16px rgba(255, 174, 51, 0.10),
                0 0 0 0 #ffe25933;
        }
    }

    .rewaardsc-pro-license-header .dashicons-awards {
        font-size: 28px;
        color: #ffb300;
        margin-bottom: 4px;
        display: inline-block;
        opacity: 1;
    }

    .rewaardsc-pro-license-header h2 {
        margin: 8px 0 4px 0;
        font-size: 1.15em;
        color: #ff9800;
        font-weight: 600;
        letter-spacing: 0.5px;
    }

    .rewaardsc-pro-license-header p {
        color: #a67c00;
        font-size: 0.98em;
        margin-bottom: 0;
    }

    .rewaardsc-pro-license-form {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 8px;
        margin-bottom: 6px;
    }

    .rewaardsc-pro-license-input {
        width: 100%;
        max-width: 220px;
        padding: 7px 10px;
        border: 1.2px solid #ffd966;
        border-radius: 6px;
        font-size: 1em;
        background: #fff;
        color: #222;
        transition: border 0.2s;
        box-shadow: 0 1px 4px rgba(255, 174, 51, 0.04);
    }

    .rewaardsc-pro-license-input:focus {
        border-color: #ffb347;
        outline: none;
    }

    .rewaardsc-pro-license-btn {
        padding: 7px 18px;
        font-size: 1em;
        border-radius: 6px;
        background: linear-gradient(90deg, #ffe259 0%, #ffa751 100%);
        border: none;
        color: #222;
        font-weight: 500;
        box-shadow: 0 1px 6px rgba(255, 174, 51, 0.08);
        transition: background 0.2s, color 0.2s;
    }

    .rewaardsc-pro-license-btn:hover {
        background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
        color: #a67c00;
    }

    .rewaardsc-pro-license-status {
        margin-top: 4px;
        min-height: 20px;
        opacity: 0;
        animation: rewaardscFadeIn 0.6s 0.4s forwards;
        font-size: 0.98em;
    }

    .rewaardsc-pro-valid {
        color: #32a852;
        font-weight: 500;
    }

    .rewaardsc-pro-invalid {
        color: #e53935;
        font-weight: 500;
    }

    .rewaardsc-pro-expiration {
        color: #a67c00;
        font-size: 0.95em;
        margin-top: 2px;
        opacity: 0;
        animation: rewaardscSlideIn 0.6s 0.6s forwards;
    }

    .rewaardsc-pro-license-message {
        margin-top: 8px;
        color: #444;
        background: #fffde7;
        border-radius: 5px;
        padding: 6px 10px;
        font-size: 0.97em;
        border: 1px solid #ffe59a;
        display: inline-block;
        opacity: 0;
        animation: rewaardscFadeIn 0.6s 0.6s forwards;
    }

    .rewaardsc-pro-license-help {
        margin-top: 14px;
        color: #a67c00;
        font-size: 0.98em;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        opacity: 0;
        animation: rewaardscFadeIn 0.6s 0.8s forwards;
    }

    .rewaardsc-pro-license-help .dashicons-cart {
        font-size: 18px;
        color: #ff9800;
        vertical-align: middle;
    }

    @media (max-width: 600px) {
        .rewaardsc-pro-license-box {
            padding: 12px 2vw 10px 2vw;
        }
        .rewaardsc-pro-license-header h2 {
            font-size: 1em;
        }
        .rewaardsc-pro-license-input {
            font-size: 0.97em;
        }
    }
    /* Animations */
    @keyframes rewaardscFadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    @keyframes rewaardscPulse {
        0% { box-shadow: 0 0 0 0 #ffe25988; }
        70% { box-shadow: 0 0 0 8px #ffe25900; }
        100% { box-shadow: 0 0 0 0 #ffe25900; }
    }
    @keyframes rewaardscRotateIn {
        0% { opacity: 0; transform: rotate(-90deg) scale(0.5);}
        100% { opacity: 1; transform: rotate(0deg) scale(1);}
    }
    @keyframes rewaardscSlideIn {
        0% { opacity: 0; transform: translateY(20px);}
        100% { opacity: 1; transform: translateY(0);}
    }
    </style>

    <div class="rewaardsc-pro-compare-table-wrap">
        <h3 class="rewaardsc-pro-compare-title"><?php esc_html_e('Comparatif des fonctionnalités', 'reewards'); ?></h3>
        <div class="rewaardsc-pro-compare-table">
            <div class="rewaardsc-pro-compare-row rewaardsc-pro-compare-head">
                <div class="rewaardsc-pro-compare-cell"></div>
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Gratuit', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell pro"><?php esc_html_e('PRO', 'reewards'); ?></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Création de concours illimitée', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Modification du design', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Tirage automatique à la fin du concours', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Création illimitée de récompenses', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Widgets Gutenberg et Elementor', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Personnalisation des emails', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Disponible en français et en anglais', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Export PDF / CSV', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-no"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Envoi d\'emails aux perdants', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-no"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Accès aux graphiques statistiques', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-no"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
            <div class="rewaardsc-pro-compare-row">
                <div class="rewaardsc-pro-compare-cell"><?php esc_html_e('Censurer le nom des gagnants', 'reewards'); ?></div>
                <div class="rewaardsc-pro-compare-cell" data-label="<?php esc_attr_e('Gratuit', 'reewards'); ?>"><span class="dashicons dashicons-no"></span></div>
                <div class="rewaardsc-pro-compare-cell pro" data-label="<?php esc_attr_e('PRO', 'reewards'); ?>"><span class="dashicons dashicons-yes"></span></div>
            </div>
        </div>
    </div>
    <style>
    .rewaardsc-pro-compare-table-wrap {
        max-width: 600px;
        margin: 38px auto 0 auto;
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 16px rgba(255, 174, 51, 0.08);
        padding: 24px 10px 18px 10px;
        font-family: 'Segoe UI', Arial, sans-serif;
    }
    .rewaardsc-pro-compare-title {
        text-align: center;
        color: #ff9800;
        font-size: 1.25em;
        font-weight: 700;
        margin-bottom: 18px;
        letter-spacing: 0.5px;
    }
    .rewaardsc-pro-compare-table {
        display: table;
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }
    .rewaardsc-pro-compare-row {
        display: table-row;
    }
    .rewaardsc-pro-compare-head {
        background: linear-gradient(90deg, #ffe259 0%, #ffa751 100%);
    }
    .rewaardsc-pro-compare-cell {
        display: table-cell;
        padding: 12px 8px;
        text-align: center;
        font-size: 1.08em;
        border-bottom: 1px solid #ffe59a;
        vertical-align: middle;
    }
    .rewaardsc-pro-compare-head .rewaardsc-pro-compare-cell {
        font-weight: bold;
        color: #a67c00;
        font-size: 1.1em;
        border-bottom: 2px solid #ffb347;
    }
    .rewaardsc-pro-compare-cell.pro {
        color: #fff;
        background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
        font-weight: bold;
        border-left: 2px solid #ffe59a;
    }
    .rewaardsc-pro-compare-row:last-child .rewaardsc-pro-compare-cell {
        border-bottom: none;
    }
    .dashicons-yes {
        color: #32a852;
        font-size: 1.3em;
    }
    .dashicons-no {
        color: #e53935;
        font-size: 1.3em;
    }
    @media (max-width: 600px) {

        .rewaardsc-pro-compare-cell.pro {
            background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
            color: #fff ;
            border-left: none;
            box-sizing: border-box;
            border-radius: 0 0 8px 8px;
            width: 100%;
            margin: 0;
        }
        .rewaardsc-pro-compare-table, .rewaardsc-pro-compare-row, .rewaardsc-pro-compare-cell {
            display: block;
            width: 100%;
        }
        .rewaardsc-pro-compare-row {
            margin-bottom: 14px;
            border-radius: 8px;
            box-shadow: 0 1px 6px rgba(255, 174, 51, 0.10);
            background: #fffbe6;
            padding: 10px 0 6px 0;
            position: relative;
        }
        .rewaardsc-pro-compare-head {
            display: none;
        }
        .rewaardsc-pro-compare-cell {
            text-align: left;
            padding: 8px 16px 8px 16px;
            border-bottom: none;
            border-left: none;
            margin-bottom: 0;
            font-size: 1em;
            position: relative;
        }
        .rewaardsc-pro-compare-cell:not(:first-child)::before {
            content: attr(data-label) " : ";
            display: inline-block;
            font-weight: bold;
            color: #ff9800;
            margin-right: 10px;
            min-width: 70px;
        }
        .rewaardsc-pro-compare-cell.pro {
            background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
            color: #fff;
            border-left: none;
        }
    }

    .rewaardsc-pro-flex-wrap {
        display: flex;
        flex-wrap: wrap;
        gap: 32px;
        justify-content: center;
        align-items: flex-start;
        margin-top: 24px;
    }
    .rewaardsc-pro-license-box,
    .rewaardsc-pro-compare-table-wrap {
        flex: 1 1 340px;
        max-width: 480px;
        min-width: 280px;
    }
    @media (max-width: 900px) {
        .rewaardsc-pro-flex-wrap {
            flex-direction: column;
            gap: 18px;
            align-items: stretch;
        }
        .rewaardsc-pro-license-box,
        .rewaardsc-pro-compare-table-wrap {
            max-width: 100%;
            min-width: 0;
            margin: 0;
        }
    }
    </style>
    <?php
}