<?php

defined('ABSPATH') || exit;

add_action('wp_ajax_rewaardsc_delete_logs', function() {
    check_ajax_referer('rewaardsc_delete_logs');
    update_option('rewaardsc_cron_logs', []);
    wp_send_json_success();
});

// Sous-menu Statistiques
add_action('admin_menu', function() {
    add_submenu_page(
        'rewaardsc-main', // Slug du menu principal
        __('Statistiques', 'reewards'),
        __('Statistiques', 'reewards'),
        'manage_options',
        'rewaardsc-stats',
        'rewaardsc_render_stats_page'
    );
});

function rewaardsc_render_stats_page() {
    $is_pro = \Reewards\Utils\License::isProUser();
    $has_plugin_pro = function_exists('rewaardsc_pro_export_pdf'); 

    wp_enqueue_script(
        'rewaardsc-stats-admin',
        plugins_url('../assets/js/stats-admin.js', __FILE__),
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . '../assets/js/stats-admin.js'),
        true
    );

    wp_localize_script(
        'rewaardsc-stats-admin',
        'rewaardscStats',
        [
            'ajaxurl' => esc_url(admin_url('admin-ajax.php')),
            'delete_logs_nonce' => wp_create_nonce('rewaardsc_delete_logs'),
            'delete_logs_confirm' => esc_js(__('Voulez-vous vraiment supprimer tous les logs ?', 'reewards')),
            'delete_logs_success' => esc_js(__('Aucun log disponible', 'reewards')),
            'delete_logs_error' => esc_js(__('Erreur lors de la suppression des logs', 'reewards')),
        ]
    );

    // Statistiques globales
    $total_concours = get_posts([
        'post_type'   => 'rewaards_concours',
        'post_status' => 'publish',
        'numberposts' => -1,
    ]);
    $total_concours = count($total_concours);

    $en_cours_query = new WP_Query([
        'post_type'   => 'rewaards_concours',
        'post_status' => 'publish',
        'meta_query'  => [[
            'key'     => 'concours_status',
            'value'   => 'en_cours',
            'compare' => '='
        ]]
    ]);
    $total_en_cours = (int) $en_cours_query->found_posts;

    $termine_query = new WP_Query([
        'post_type'   => 'rewaards_concours',
        'post_status' => 'publish',
        'meta_query'  => [[
            'key'     => 'concours_status',
            'value'   => 'termine',
            'compare' => '='
        ]]
    ]);
    $total_termine = (int) $termine_query->found_posts;

    // Total participants + données pour les graphiques
    $all_concours = get_posts([
        'post_type'   => 'rewaards_concours',
        'post_status' => 'publish',
        'numberposts' => -1
    ]);

    $total_participants  = 0;
    $concours_labels     = [];
    $participants_data   = [];
    $concours_by_month   = [];
    $participants_by_month = [];

    $top_concours_labels = [];
    $top_concours_data   = [];

    // Initialiser les 6 derniers mois
    $last_six_months = [];
    for($i=5;$i>=0;$i--){
        $month = gmdate('Y-m', strtotime("-$i month"));
        $last_six_months[$month] = 0;
        $participants_by_month[$month] = 0;
    }

    foreach ($all_concours as $concours) {
        $participants       = get_post_meta($concours->ID, 'concours_participants', true);
        $participants_count = is_array($participants) ? count($participants) : 0;

        $total_participants       += $participants_count;
        $concours_labels[]         = esc_html($concours->post_title);
        $participants_data[]       = $participants_count;

        $month = gmdate('Y-m', strtotime($concours->post_date));
        if(array_key_exists($month, $last_six_months)){
            $last_six_months[$month]++;
            $participants_by_month[$month] += $participants_count;
        }
    }

    // Top concours par participants
    $top = [];
    foreach ($all_concours as $c) {
        $p = get_post_meta($c->ID, 'concours_participants', true);
        $count = is_array($p) ? count($p) : 0;
        $top[esc_html($c->post_title)] = $count;
    }
    arsort($top);
    $top = array_slice($top, 0, 5);
    $top_concours_labels = array_keys($top);
    $top_concours_data   = array_values($top);

    // Récupérer la dernière exécution du cron
    $last_cron = get_option('rewaardsc_last_cron_run');

    ?>
    <div class="wrap">
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Général', 'reewards'); ?></h2>
        <div class="rewaardsc-kpi-grid">
            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-awards rewaardsc-color-blue" style="font-size:26px;line-height:1;"></span></div>
                <div class="rewaardsc-kpi-value rewaardsc-color-blue"><?php echo intval($total_concours); ?></div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Total des concours', 'reewards'); ?></p>
            </div>
            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-clock rewaardsc-color-green" style="font-size:26px;line-height:1;"></span></div>
                <div class="rewaardsc-kpi-value rewaardsc-color-green"><?php echo intval($total_en_cours); ?></div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Concours en cours', 'reewards'); ?></p>
            </div>
            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-yes rewaardsc-color-red" style="font-size:26px;line-height:1;"></span></div>
                <div class="rewaardsc-kpi-value rewaardsc-color-red"><?php echo intval($total_termine); ?></div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Concours terminés', 'reewards'); ?></p>
            </div>
            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-groups rewaardsc-color-blue" style="font-size:26px;line-height:1;"></span></div>
                <div class="rewaardsc-kpi-value rewaardsc-color-blue"><?php echo intval($total_participants); ?></div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Total des participants', 'reewards'); ?></p>
            </div>
        </div>

        <!-- Graphiques -->
         <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Graphiques', 'reewards'); ?></h2>
        <?php if ($is_pro && !$has_plugin_pro): ?>
            <div class="rewaardsc-pro-alert" style="
                background: #fff0f0;
                border: 1.5px solid #dc3545;
                color: #dc3545;
                padding: 18px 22px;
                border-radius: 7px;
                font-size: 16px;
                font-weight: bold;
                margin-bottom: 22px;
                display: flex;
                align-items: center;
                gap: 12px;
                box-shadow: 0 2px 8px rgba(220,53,69,0.07);
                ">
                <span style="font-size:22px;line-height:1;">&#9888;&#65039;</span>
                <?php esc_html_e('Votre licence PRO est valide, mais le plugin PRO n\'est pas installé ou activé.<br>Veuillez installer le plugin PRO pour accéder aux graphiques et fonctionnalités avancées.', 'reewards'); ?>
            </div>
        <?php endif; ?>
         <div class="rewaardsc-graph-grid">


            <div class="rewaardsc-graph-card rewaardsc-kpi-card rewaardsc-animate-card" style="position:relative;">
                <h2><?php esc_html_e('Participants par concours', 'reewards'); ?></h2>
                <?php if(!$is_pro): ?>
                    <div class="rewaardsc-pro-overlay">
                        <a href="admin.php?page=reewards-settings&tab=pro" class="rewaardsc-pro-message" style="display:inline-block; text-decoration:none; color:inherit; cursor:pointer;">
                            <?php esc_html_e('Réservé aux PRO', 'reewards'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="<?php echo !$is_pro ? 'rewaardsc-blur' : ''; ?>">
                    <canvas id="participantsChart" height="200"></canvas>
                </div>
            </div>

            <div class="rewaardsc-graph-card rewaardsc-kpi-card rewaardsc-animate-card" style="position:relative;">
                <h2><?php esc_html_e('Concours par mois', 'reewards'); ?></h2>
                <?php if(!$is_pro): ?>
                    <div class="rewaardsc-pro-overlay">
                        <a href="admin.php?page=reewards-settings&tab=pro" class="rewaardsc-pro-message" style="display:inline-block; text-decoration:none; color:inherit; cursor:pointer;">
                            <?php esc_html_e('Réservé aux PRO', 'reewards'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                
                <div class="<?php echo !$is_pro ? 'rewaardsc-blur' : ''; ?>">
                    <canvas id="concoursMonthChart" height="200"></canvas>
                </div>
            </div>


            <div class="rewaardsc-graph-card rewaardsc-kpi-card rewaardsc-animate-card" style="position:relative;">
                <h2><?php esc_html_e('Participants par mois', 'reewards'); ?></h2>
                <?php if(!$is_pro): ?>
                    <div class="rewaardsc-pro-overlay">
                        <a href="admin.php?page=reewards-settings&tab=pro" class="rewaardsc-pro-message" style="display:inline-block; text-decoration:none; color:inherit; cursor:pointer;">
                            <?php esc_html_e('Réservé aux PRO', 'reewards'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                
                <div class="<?php echo !$is_pro ? 'rewaardsc-blur' : ''; ?>">
                    <canvas id="participantsMonthChart" height="200"></canvas>
                </div>
            </div>


            <div class="rewaardsc-graph-card rewaardsc-kpi-card rewaardsc-animate-card" style="position:relative;">
                <h2><?php esc_html_e('Top concours par participants', 'reewards'); ?></h2>
                <?php if(!$is_pro): ?>
                    <div class="rewaardsc-pro-overlay">
                        <a href="admin.php?page=reewards-settings&tab=pro" class="rewaardsc-pro-message" style="display:inline-block; text-decoration:none; color:inherit; cursor:pointer;">
                            <?php esc_html_e('Réservé aux PRO', 'reewards'); ?>
                        </a>
                    </div>
                <?php endif; ?>
                
                <div class="<?php echo !$is_pro ? 'rewaardsc-blur' : ''; ?>">
                    <canvas id="topConcoursChart" height="200"></canvas>
                </div>
            </div>
        </div>

        <!-- Cron -->
        <h2 class="rewaardsc-section-title" style="margin-top:30px;"><?php esc_html_e('Cron', 'reewards'); ?></h2>
        <div class="rewaardsc-kpi-grid">
            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-update-alt rewaardsc-color-blue" style="font-size:26px;line-height:1;"></span></div>
                <div class="rewaardsc-kpi-value rewaardsc-color-blue">
                    <?php
                        if ($last_cron) {
                            echo esc_html(date_i18n('d/m/Y H:i:s', strtotime($last_cron)));
                        } else {
                            echo esc_html__('Jamais exécuté', 'reewards');
                        }
                    ?>
                </div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Dernière exécution du cron', 'reewards'); ?></p>
            </div>

            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon"><span class="dashicons dashicons-clock rewaardsc-color-blue" style="font-size:26px;line-height:1;"></span></div>
                <div id="cron-elapsed" class="rewaardsc-kpi-value rewaardsc-color-blue">--:--</div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Temps écoulé', 'reewards'); ?></p>
            </div>

            <div class="rewaardsc-kpi-card rewaardsc-animate-card">
                <?php
                    $cron_ok = false;
                    if ($last_cron) {
                        $last_timestamp = strtotime($last_cron);
                        if ((time() - $last_timestamp) <= 5 * 60) { // moins de 5 minutes
                            $cron_ok = true;
                        }
                    }
                ?>
                <div class="rewaardsc-kpi-icon">
                    <?php if ($cron_ok): ?>
                        <span class="dashicons dashicons-yes rewaardsc-color-green" style="font-size:26px;line-height:1;"></span>
                    <?php else: ?>
                        <span class="dashicons dashicons-no-alt rewaardsc-color-red" style="font-size:26px;line-height:1;"></span>
                    <?php endif; ?>
                </div>
                <div class="rewaardsc-kpi-value <?php echo $cron_ok ? 'rewaardsc-color-green' : 'rewaardsc-color-red'; ?>">
                    <?php echo $cron_ok ? esc_html__('Le cron fonctionne ✅', 'reewards') : esc_html__('Le cron ne fonctionne pas ❌', 'reewards'); ?>
                </div>
            </div>

            <!-- Logs du plugin : prend toute la largeur de la grille -->
            <div class="rewaardsc-kpi-card rewaardsc-logs-card rewaardsc-animate-card">
                <div class="rewaardsc-kpi-icon">
                    <span class="dashicons dashicons-list-view rewaardsc-color-blue" style="font-size:26px;line-height:1;"></span>
                </div>
                <p class="rewaardsc-kpi-label"><?php esc_html_e('Logs du plugin', 'reewards'); ?></p>

                <div style="position:absolute; top:10px; right:10px; display:flex; gap:5px;">
                    <button id="copy-logs-btn" style="padding:4px 8px; font-size:12px; cursor:pointer; border:none; background:#0073aa; color:#fff; border-radius:4px;">
                        <?php esc_html_e('📑 Copier', 'reewards'); ?>
                    </button>
                    <button id="export-logs-btn" style="padding:4px 8px; font-size:12px; cursor:pointer; border:none; background:#595959; color:#fff; border-radius:4px;">
                        <?php esc_html_e('💾 Exporter', 'reewards'); ?>
                    </button>
                    <button id="delete-logs-btn" style="padding:4px 8px; font-size:12px; cursor:pointer; border:none; background:#dc3545; color:#fff; border-radius:4px;">
                        <?php esc_html_e('🗑️ Supprimer', 'reewards'); ?>
                    </button>
                </div>

                <br><br>
                <div id="rewaardsc-logs-content" style="font-size:14px; color:#333; max-height:300px; overflow:auto;">
                    <?php
                    $logs = get_option('rewaardsc_cron_logs', []);
                    if(!empty($logs)){
                        $logs = array_reverse($logs);
                        echo esc_html('<pre>' . implode("\n", $logs) . '</pre>');
                    } else {
                        echo esc_html('Aucun log disponible', 'reewards');
                    }
                    ?>
                </div>
            </div>

            
        </div>
        <div id="rewaardsc-modal-overlay" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(0,0,0,0.3);z-index:9999;">
            <div id="rewaardsc-modal" style="background:#fff;padding:24px 20px 16px 20px;max-width:350px;margin:10vh auto 0 auto;border-radius:8px;box-shadow:0 8px 32px rgba(0,0,0,0.15);position:relative;">
                <h3 style="margin-top:0;"><?php esc_html_e('Confirmation', 'reewards'); ?></h3>
                <p style="margin-bottom:24px;"><?php esc_html_e('Voulez-vous vraiment supprimer tous les logs ? Cette action est irréversible.', 'reewards'); ?></p>
                <div style="text-align:right;">
                    <button id="rewaardsc-modal-cancel" style="margin-right:8px;padding:6px 16px;border:none;background:#ccc;color:#222;border-radius:4px;cursor:pointer;"><?php esc_html_e('Annuler', 'reewards'); ?></button>
                    <button id="rewaardsc-modal-confirm" style="padding:6px 16px;border:none;background:#dc3545;color:#fff;border-radius:4px;cursor:pointer;"><?php esc_html_e('Supprimer', 'reewards'); ?></button>
                </div>
            </div>
        </div>
    </div><!-- .wrap -->
    <script>
        var rewaardsc_delete_logs_nonce = "<?php echo esc_attr(wp_create_nonce('rewaardsc_delete_logs')); ?>";
    </script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php if ($is_pro): ?>
        function initChart(){
            if (typeof Chart === 'undefined') {
                return setTimeout(initChart, 50);
            }

            // Participants par concours
            new Chart(document.getElementById('participantsChart').getContext('2d'), {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($concours_labels); ?>,
                    datasets: [{
                        label: '<?php echo esc_js(__('Participants', 'reewards')); ?>',
                        data: <?php echo json_encode($participants_data); ?>,
                        borderColor: '#0073aa',
                        backgroundColor: 'rgba(0,115,170,0.2)',
                        fill: true,
                        tension: 0.3
                    }]
                },
                options: { responsive: true, plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true } } }
            });

            // Concours par mois
            new Chart(document.getElementById('concoursMonthChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode(array_keys($last_six_months)); ?>,
                    datasets: [{
                        label: '<?php echo esc_js(__('Concours', 'reewards')); ?>',
                        data: <?php echo json_encode(array_values($last_six_months)); ?>,
                        backgroundColor: '#28a745'
                    }]
                },
                options: { responsive: true, plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true, precision:0 } } }
            });

            // Participants par mois
            new Chart(document.getElementById('participantsMonthChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode(array_keys($participants_by_month)); ?>,
                    datasets: [{
                        label: '<?php echo esc_js(__('Participants', 'reewards')); ?>',
                        data: <?php echo json_encode(array_values($participants_by_month)); ?>,
                        backgroundColor: '#0073aa'
                    }]
                },
                options: { responsive: true, plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true, precision:0 } } }
            });

            // Top concours par participants
            new Chart(document.getElementById('topConcoursChart').getContext('2d'), {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($top_concours_labels); ?>,
                    datasets: [{
                        label: '<?php echo esc_js(__('Participants', 'reewards')); ?>',
                        data: <?php echo json_encode($top_concours_data); ?>,
                        backgroundColor: '#dc3545'
                    }]
                },
                options: { responsive: true, indexAxis: 'y', plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true, precision:0 } } }
            });
        }

        initChart();
        <?php endif; ?>

        // Compteur Temps écoulé
        <?php if ($last_cron): ?>
        (function(){
            const lastCron = new Date("<?php echo esc_js($last_cron); ?>").getTime();
            const display  = document.getElementById("cron-elapsed");
            function updateElapsed(){
                const now = new Date().getTime();
                let diff = Math.floor((now - lastCron)/1000);
                if(diff < 0) diff = 0;
                const minutes = Math.floor(diff/60);
                const seconds = diff % 60;
                display.textContent =
                    String(minutes).padStart(2,"0") + ":" + String(seconds).padStart(2,"0");
            }
            setInterval(updateElapsed, 1000);
            updateElapsed();
        })();
        <?php endif; ?>
    });
    </script>
<?php
}