jQuery(document).ready(function($){
    //JS page création concours
    $('.reward-card').on('click', function(e){
        // Ne pas déclencher si on clique sur l'input quantité
        if($(e.target).is('input[type="number"]')) return;

        var checkbox = $(this).find('.reward-checkbox');
        var qtyInput = $(this).find('.reward-qty');

        // Toggle sélection
        var selected = !checkbox.prop('checked');
        checkbox.prop('checked', selected);
        $(this).toggleClass('selected', selected);

        // Affiche/masque le checkmark
        $(this).find('.reward-checkmark').toggle(selected);

        // Si sélectionné et quantité = 0, passer à 1
        if(selected && parseInt(qtyInput.val()) === 0){
            qtyInput.val(1);
        }else{
            qtyInput.val(0);
        }
    });

    // Si utilisateur change quantité manuellement à >0, coche la carte automatiquement
    $('.reward-qty').on('input', function(){
        var card = $(this).closest('.reward-card');
        var checkbox = card.find('.reward-checkbox');
        var selected = parseInt($(this).val()) > 0;
        checkbox.prop('checked', selected);
        card.toggleClass('selected', selected);
        card.find('.reward-checkmark').toggle(selected);
    });




    
});


//Lister les concours
jQuery(document).ready(function($){
    $('.rewaardsc-delete-btn').on('click', function(e){
        if(!confirm(window.rewaardscAdminI18n.confirmDelete)) {
            e.preventDefault();
        }
    });
});


// Visualisation/édition d'un concours : gestion des cartes récompenses
jQuery(document).ready(function($){
    // Clic sur la carte => toggle sélection + gestion quantité min
    $('.rewaardsc-reward-card').on('click', function(e){
        if($(e.target).is('input[type="number"]')) return;

        var card     = $(this);
        var checkbox = card.find('.reward-checkbox');
        var qtyInput = card.find('.reward-qty');

        var select = !checkbox.prop('checked');
        checkbox.prop('checked', select);
        card.toggleClass('selected', select);
        card.find('.reward-checkmark').toggle(select);

        if(select && parseInt(qtyInput.val(),10) === 0){
            qtyInput.val(1);
        }
        if(!select){
            qtyInput.val(0);
        }
    });

    // Saisie quantité => coche/décoche + min 1 si >0
    $('.reward-qty').on('input', function(){
        var card     = $(this).closest('.rewaardsc-reward-card');
        var checkbox = card.find('.reward-checkbox');
        var val      = parseInt($(this).val(),10) || 0;

        if(val > 0){
            checkbox.prop('checked', true);
            card.addClass('selected');
            card.find('.reward-checkmark').show();
            if(val < 1) $(this).val(1);
        } else {
            checkbox.prop('checked', false);
            card.removeClass('selected');
            card.find('.reward-checkmark').hide();
        }
    });
});


