

window.rewaardscProCheck = function(isPro, message) {
    if (isPro) return true;

    // Supprime une éventuelle popup déjà présente
    let old = document.getElementById('rewaardsc-pro-modal');
    if (old) old.remove();

    // Crée le fond
    let overlay = document.createElement('div');
    overlay.id = 'rewaardsc-pro-modal';
    overlay.innerHTML = `
        <div class="rewaardsc-pro-modal-content">
            <div class="rewaardsc-pro-modal-header">
                <span class="dashicons dashicons-lock"></span>
                <h2>${window.rewaardscProModalI18n.title}</h2>
            </div>
            <div class="rewaardsc-pro-modal-body">
                <p>${message || window.rewaardscProModalI18n.message}</p>
            </div>
            <div class="rewaardsc-pro-modal-footer">
                <button id="rewaardsc-pro-modal-close">${window.rewaardscProModalI18n.close}</button>
                <a href="admin.php?page=rewaards-concours-settings&tab=pro" target="_blank" class="rewaardsc-pro-modal-btn">${window.rewaardscProModalI18n.becomePro}</a>
            </div>
        </div>
    `;
    document.body.appendChild(overlay);

    // Fermer la popup
    document.getElementById('rewaardsc-pro-modal-close').onclick = function() {
        overlay.remove();
    };
    overlay.onclick = function(e) {
        if (e.target === overlay) overlay.remove();
    };

    // Ajoute le style si pas déjà présent
    if (!document.getElementById('rewaardsc-pro-modal-style')) {
        let style = document.createElement('style');
        style.id = 'rewaardsc-pro-modal-style';
        style.innerHTML = `
            #rewaardsc-pro-modal {
                position: fixed; z-index: 99999; left: 0; top: 0; width: 100vw; height: 100vh;
                background: rgba(0,0,0,0.35); display: flex; align-items: center; justify-content: center;
                animation: rewaardscProModalFadeIn 0.2s;
            }
            @keyframes rewaardscProModalFadeIn { from { opacity: 0; } to { opacity: 1; } }
            .rewaardsc-pro-modal-content {
                background: #fff; border-radius: 14px; max-width: 95vw; width: 370px; box-shadow: 0 8px 32px rgba(0,0,0,0.13);
                padding: 28px 22px 18px 22px; text-align: center; position: relative; animation: rewaardscProModalPop 0.25s;
            }
            @keyframes rewaardscProModalPop { from { transform: scale(0.92); opacity: 0; } to { transform: scale(1); opacity: 1; } }
            .rewaardsc-pro-modal-header { margin-bottom: 10px; }
            .rewaardsc-pro-modal-header .dashicons-lock {
                font-size: 32px; color: #ff9800; vertical-align: middle; margin-bottom: 4px; display: inline-block;
            }
            .rewaardsc-pro-modal-header h2 {
                margin: 8px 0 0 0; font-size: 1.3em; color: #ff9800; font-weight: 700;
            }
            .rewaardsc-pro-modal-body p {
                color: #444; font-size: 1.08em; margin: 0 0 10px 0;
            }
            .rewaardsc-pro-modal-footer {
                display: flex; gap: 12px; justify-content: center; margin-top: 10px; flex-wrap: wrap;
            }
            .rewaardsc-pro-modal-btn, #rewaardsc-pro-modal-close {
                padding: 8px 22px; border-radius: 7px; border: none; font-size: 1em; font-weight: 600; cursor: pointer;
                transition: background 0.2s, color 0.2s;
            }
            #rewaardsc-pro-modal-close {
                background: #eee; color: #444;
            }
            #rewaardsc-pro-modal-close:hover {
                background: #ddd; color: #222;
            }
            .rewaardsc-pro-modal-btn {
                background: linear-gradient(90deg, #ffe259 0%, #ffa751 100%);
                color: #a67c00; text-decoration: none; border: none;
            }
            .rewaardsc-pro-modal-btn:hover {
                background: linear-gradient(90deg, #ffb347 0%, #ffcc33 100%);
                color: #fff;
            }
            @media (max-width: 500px) {
                .rewaardsc-pro-modal-content { width: 98vw; padding: 18px 4vw 12px 4vw; }
                .rewaardsc-pro-modal-header h2 { font-size: 1.1em; }
            }
        `;
        document.head.appendChild(style);
    }

    return false;
};