jQuery(document).ready(function($){
    // Copier les logs
    $('#copy-logs-btn').on('click', function() {
        let textToCopy = $('#rewaardsc-logs-content').text();
        navigator.clipboard.writeText(textToCopy).then(() => {
            $(this).text('✅ Copié !');
            setTimeout(() => { $(this).text('📑 Copier'); }, 1500);
        }).catch(() => {
            alert('Impossible de copier les logs');
        });
    });

    // Exporter les logs
    $('#export-logs-btn').on('click', function() {
        let textToExport = $('#rewaardsc-logs-content').text();
        let blob = new Blob([textToExport], { type: 'text/plain' });
        let url = URL.createObjectURL(blob);
        let a = document.createElement('a');
        a.href = url;
        a.download = 'logs_plugin_awards.txt';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
    });

    $('#delete-logs-btn').on('click', function() {
        $('#rewaardsc-modal-overlay').fadeIn(150);
    });

    $('#rewaardsc-modal-cancel').on('click', function() {
        $('#rewaardsc-modal-overlay').fadeOut(150);
    });

    $('#rewaardsc-modal-confirm').on('click', function() {
        $.post(rewaardscStats.ajaxurl, {
            action: 'rewaardsc_delete_logs',
            _wpnonce: rewaardscStats.delete_logs_nonce
        }, function(response) {
            $('#rewaardsc-modal-overlay').fadeOut(150);
            if (response.success) {
                $('#rewaardsc-logs-content').text(rewaardscStats.delete_logs_success);
            } else {
                alert(rewaardscStats.delete_logs_error);
            }
        });
    });
});