<?php
/**
 * Plugin Name: MG Reewards — Giveaways & Rewards
 * Description: Plugin de tirage au sort & giveaways
 * Version: 1.0.0
 * Author: MG Plugins
 * Text Domain: reewards
 * License: GPLv2 or later
 * Domain Path: /languages
 */

// Protection contre l'accès direct
defined('ABSPATH') || exit;

// Autoloading simple pour les classes du plugin
spl_autoload_register(function ($class) {
    if (strpos($class, 'Reewards\\') === 0) {
        $path = __DIR__ . '/src/' . str_replace('\\', '/', substr($class, strlen('Reewards\\'))) . '.php';
        if (file_exists($path)) {
            require_once $path;
        }
    }
});

// Inclure la page de création de concours dans l'admin
if (is_admin()) {
    require_once __DIR__ . '/admin/settings/settings-page.php';
    require_once __DIR__ . '/admin/create-page.php';
    require_once __DIR__ . '/admin/liste-page.php';
    require_once __DIR__ . '/admin/rewaardsc-view-concours-page.php';
    require_once __DIR__ . '/admin/rewards-page.php';
    require_once __DIR__ . '/admin/stats-page.php';
}

require_once plugin_dir_path(__FILE__) . 'src/Domain/TirageService.php';
require_once plugin_dir_path(__FILE__) . 'src/Utils/Cron.php';
require_once plugin_dir_path(__FILE__) . 'src/Frontend/HistoriqueShortcode.php';
require_once plugin_dir_path(__FILE__) . 'src/Frontend/ParticipationShortcode.php';
require_once plugin_dir_path(__FILE__) . 'src/Utils/Licence.php';
require_once plugin_dir_path(__FILE__) . 'src/Utils/Format.php';
require_once plugin_dir_path(__FILE__) . 'src/Utils/ProField.php';

// CSS et JS Admin
add_action('admin_enqueue_scripts', function ($hook) {
    if (
        isset($_GET['page']) && // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        strpos( sanitize_text_field( wp_unslash( $_GET['page'] ) ), 'rewaardsc-' ) === 0 // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    ) {
        wp_enqueue_style(
            'reewards-admin',
            plugins_url('assets/css/admin.css', __FILE__),
            [],
            filemtime(plugin_dir_path(__FILE__) . 'assets/css/admin.css')
        );

        wp_enqueue_script(
            'reewards-admin',
            plugins_url('assets/js/admin.js', __FILE__),
            ['jquery'],
            filemtime(plugin_dir_path(__FILE__) . 'assets/js/admin.js'),
            true
        );
    }
});

// Hook de désactivation
register_deactivation_hook(__FILE__, function () {
    wp_clear_scheduled_hook('rewaardsc_cron_event');
    wp_clear_scheduled_hook('rewaardsc_check_license_cron');
});

// Cron
use Reewards\Utils\Cron;
use Reewards\Utils\LicenceCron;

// Ajout de l'intervalle personnalisé
add_filter('cron_schedules', [Cron::class, 'registerSchedule']);

// Planification à l'activation
register_activation_hook(__FILE__, [Cron::class, 'scheduleEvent']);

// Hook principal du cron
add_action('rewaardsc_cron_event', [Cron::class, 'verifierTirages']);

// Inclure la classe LicenceCron
require_once plugin_dir_path(__FILE__) . 'src/Utils/LicenceCron.php';

// Planification et suppression du cron à l'activation/désactivation
register_activation_hook(__FILE__, [LicenceCron::class, 'scheduleEvent']);

// Hook pour exécuter la vérification
add_action('rewaardsc_check_license_cron', ['Reewards\Utils\LicenceCron', 'checkLicense']);

// Traductions
add_action('init', function () {
    $selected = get_option('rewaardsc_plugin_language');
    if ($selected && in_array($selected, ['fr_FR', 'en_US'])) {
        $mofile = dirname(__FILE__) . '/languages/reewards-' . $selected . '.mo';
        if (file_exists($mofile)) {
            unload_textdomain('reewards');
            load_textdomain('reewards', $mofile);
            return;
        }
    }
});

// Liens dans la liste des plugins
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function ($links) {
    $pro_link = sprintf(
        '<a href="%s" target="_blank" style="color:#ff9800;font-weight:bold;">%s</a>',
        esc_url('https://mg-plugins.com/plugin/reewards/'),
        esc_html__('Devenir PRO', 'reewards')
    );
    $settings_link = sprintf(
        '<a href="%s" style="font-weight:bold;">%s</a>',
        esc_url(admin_url('admin.php?page=reewards-settings')),
        esc_html__('Réglages', 'reewards')
    );
    array_unshift($links, $settings_link);
    array_unshift($links, $pro_link);
    return $links;
});

// Classe de désinstallation
class Rewaardsc_Uninstall {
    public static function uninstall() {
        wp_clear_scheduled_hook('rewaardsc_cron_event');
        wp_clear_scheduled_hook('rewaardsc_check_license_cron');
    }
}

// Enregistrez le hook de désinstallation
register_uninstall_hook(__FILE__, ['Rewaardsc_Uninstall', 'uninstall']);