<?php
namespace Reewards\Domain;

/**
 * Gère les opérations sur les concours.
 */
class ConcoursManager
{
    /**
     * Crée un concours WordPress.
     * @param array $data Données du concours (nom, start, end, winners_count, rewards, etc.)
     * @return int|WP_Error L'ID du concours créé ou une erreur WP_Error.
     */
    public static function create($data)
    {
        // Création du post concours
        $post_id = wp_insert_post([
            'post_title'   => $data['nom'],
            'post_type'    => 'rewaards_concours',
            'post_status'  => 'publish',
        ]);

        if (is_wp_error($post_id)) {
            return $post_id;
        }

        // Ajout des métadonnées
        update_post_meta($post_id, 'concours_start', $data['start']);
        update_post_meta($post_id, 'concours_status', $data['concours_status']);
        update_post_meta($post_id, 'concours_end', $data['end']);
        update_post_meta($post_id, 'concours_winners_count', $data['winners_count']);
        update_post_meta($post_id, 'concours_rewards', $data['rewards']);
        update_post_meta($post_id, 'concours_participants', []);
        update_post_meta($post_id, 'concours_gagnants', []);
        

        return $post_id;
    }


    /**
     * Récupère une liste paginée de concours avec filtre par statut.
     */
    public static function getList($paged = 1, $posts_per_page = 10, $status = '')
    {
        $meta_query = [];
        if ($status === 'en_cours' || $status === 'termine') {
            $meta_query[] = [
                'key' => 'concours_status',
                'value' => $status,
                'compare' => '='
            ];
        }

        $query = new \WP_Query([
            'post_type'      => 'rewaards_concours',
            'posts_per_page' => $posts_per_page,
            'paged'          => $paged,
            'post_status'    => 'publish',
            'meta_query'     => $meta_query
        ]);
        return $query;
    }

    /**
     * Supprime un concours par ID.
     */
    public static function delete($id)
    {
        return wp_delete_post($id, true);
    }

    /**
     * Marque un concours comme terminé.
     */
    public static function markTermine($id)
    {
        update_post_meta($id, 'concours_status', 'termine');
        update_post_meta($id, 'concours_end', current_time('mysql'));
        // Appelle la fonction de tirage si elle existe
        if (function_exists('rewaardsc_lancer_tirage')) {
            rewaardsc_lancer_tirage($id);
        }
    }

}