<?php
namespace Reewards\Frontend;
use Reewards\Utils\Format;
if (!defined('ABSPATH')) exit;

class ParticipationShortcode
{
    public static function render() {
        ob_start();
        $now = current_time('Y-m-d H:i:s');

        $main_color = get_option('rewaardsc_theme_color', '#0170B9');
        $text_color = get_option('rewaardsc_text_color', '#ffffff');
        $emoji = get_option('rewaardsc_theme_emoji', '🎁');
        $emoji_densite = get_option('rewaardsc_theme_emoji_densite', '15');
        $show_participants_count = get_option('rewaardsc_show_participants_count', false) ? 1 : 0;

        if (function_exists('wc_get_page_id') && wc_get_page_id('myaccount') > 0) {
            $mon_compte_url = get_permalink(wc_get_page_id('myaccount'));
        } else {
            $mon_compte_url = wp_login_url();
        }


        $countdown_bg_color = get_option('rewaardsc_countdown_bg_color', '#d64848ff');
        $countdown_text_color = get_option('rewaardsc_countdown_text_color', '#ffffff');

        // Helper pour foncer la couleur
        $darken_color = function($color, $percent) {
            $color = str_replace('#','',$color);
            $r = hexdec(substr($color,0,2));
            $g = hexdec(substr($color,2,2));
            $b = hexdec(substr($color,4,2));

            $r = max(0, min(255, (int)round($r - ($r * $percent / 100))));
            $g = max(0, min(255, (int)round($g - ($g * $percent / 100))));
            $b = max(0, min(255, (int)round($b - ($b * $percent / 100))));

            return '#' . str_pad(dechex($r),2,'0',STR_PAD_LEFT)
                    . str_pad(dechex($g),2,'0',STR_PAD_LEFT)
                    . str_pad(dechex($b),2,'0',STR_PAD_LEFT);
        };

        // Textes traduisibles
        $txt_aucun_concours = esc_html__('Aucun concours n\'est actuellement en cours.', 'reewards');
        $txt_precedent = esc_html__('Précédent', 'reewards');
        $txt_suivant = esc_html__('Suivant', 'reewards');
        $txt_date_debut = esc_html__('Date de début', 'reewards');
        $txt_date_fin = esc_html__('Date de fin', 'reewards');
        $txt_nb_gagnants = esc_html__('Nombre de gagnants', 'reewards');
        $txt_nb_participants = esc_html__('Nombre de participants', 'reewards');
        $txt_tirage = esc_html__('Tirage au sort', 'reewards');
        $txt_temps_restant = esc_html__('Temps restant avant le tirage', 'reewards');
        $txt_tirage_fini = esc_html__('Le tirage a eu lieu !', 'reewards');
        $txt_recompenses = esc_html__('Récompenses', 'reewards');
        $txt_participer = esc_html__('Participer', 'reewards');
        $txt_connecte = esc_html__('Tu dois être connecté pour participer au concours.', 'reewards');
        $txt_inscrit = esc_html__('🎉 Tu es inscrit au concours !', 'reewards');
        $txt_deja_inscrit = esc_html__('⚠️ Tu es déjà inscrit.', 'reewards');
        $txt_pseudo = esc_html__('Pseudo', 'reewards');
        $txt_email = esc_html__('Email', 'reewards');
        $txt_fermer = esc_html__('Fermer', 'reewards');
        $txt_connexion = esc_html__('Se connecter / S\'inscrire', 'reewards');

        // Récupérer les concours en cours
        $args = [
            'post_type' => 'rewaards_concours',
            'posts_per_page' => -1,
            'meta_query' => [
                'relation' => 'AND',
                [
                    'key'     => 'concours_status',
                    'value'   => 'en_cours',
                ],
                [
                    'key'     => 'concours_end',
                    'value'   => gmdate('Y-m-d'),
                    'compare' => '>=',
                    'type'    => 'DATE'
                ]
            ],
            'orderby'  => 'meta_value',
            'meta_key' => 'concours_end',
            'order'    => 'ASC'
        ];

        $query = new \WP_Query($args);

        $concours_list = [];
        while($query->have_posts()) {
            $query->the_post();
            $date_start_raw = get_post_meta(get_the_ID(), 'concours_start', true);
            $date_end_raw = get_post_meta(get_the_ID(), 'concours_end', true);
            $concours_list[] = [
                'ID' => get_the_ID(),
                'nom' => get_the_title(),
                'date_start_raw' => get_post_meta(get_the_ID(), 'concours_start', true),
                'date_end_raw' => get_post_meta(get_the_ID(), 'concours_end', true),
                'date_start' => Format::datetime($date_start_raw),
                'date_end' => Format::datetime($date_end_raw),
                'winners_count' => get_post_meta(get_the_ID(), 'concours_winners_count', true),
                'rewards' => get_post_meta(get_the_ID(), 'concours_rewards', true),
                'participants' => get_post_meta(get_the_ID(), 'concours_participants', true),
                'participants_count' => is_array(get_post_meta(get_the_ID(), 'concours_participants', true)) ? count(get_post_meta(get_the_ID(), 'concours_participants', true)) : 0,
            ];
        }
        wp_reset_postdata();

        if(empty($concours_list)) {
            echo '<p>' . esc_html($txt_aucun_concours) . '</p>';
            return ob_get_clean();
        }
        ?>
        <style>
        /* Bandeau titre concours */
        .rewaardsc-concours-title {
            position: relative;
            color: <?php echo esc_attr($text_color); ?>;
            padding: 10px 15px;
            text-align: center;
            border-radius: 10px;
            overflow: hidden;
            font-weight: bold;
            background: <?php echo esc_attr($main_color); ?>;
            transition: transform 0.3s;
        }
        .rewaardsc-concours-title:hover {
            transform: scale(1.05);
            cursor:pointer;
        }
        .rewaardsc-concours-title::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            overflow: hidden;
        }
        .rewaardsc-concours-title span {
            position: relative;
            z-index: 2;
        }
        .gift {
            position: absolute;
            font-size: 20px;
            opacity: 0.4;
            animation-name: fall;
            animation-timing-function: linear;
            animation-iteration-count: infinite;
        }
        @keyframes fall {
            0% { transform: translateY(-50px); opacity: 0; }
            10% { opacity: 0.8; }
            100% { transform: translateY(120%); opacity: 0; }
        }
        .rewaardsc-reward-card {
            flex:1 1 120px;
            min-width:120px;
            max-width:150px;
            background: linear-gradient(135deg, #ffffff, #e6f0fa);
            border-radius:15px;
            padding:15px;
            text-align:center;
            box-shadow: 0 6px 10px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            cursor:pointer;
        }
        .rewaardsc-reward-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 20px rgba(0,0,0,0.2);
        }
        .rewaardsc-participer-btn {
            padding:15px 40px; 
            background:<?php echo esc_attr($main_color); ?>; 
            color: <?php echo esc_attr($text_color); ?>; 
            border:none; 
            border-radius:10px; 
            font-size:18px; 
            font-weight:bold; 
            cursor:pointer; 
            transition: background 0.3s, transform 0.2s;
        }
        .rewaardsc-participer-btn:hover {
            background:<?php echo esc_attr($darken_color($main_color, 20)); ?> !important;
            transform: scale(1.05);
        }
        #rewaardsc-popup {
            position:fixed;
            top:0; left:0;
            width:100%; height:100vh;
            background:rgba(0,0,0,0.6);
            z-index:99999;
            display:flex;
            justify-content:center;
            align-items:center;
            opacity:0;
            pointer-events:none;
            transition: opacity 0.3s ease;
        }
        #rewaardsc-popup .rewaardsc-popup-content {
            background:#fff;
            padding:20px;
            border-radius:10px;
            max-width:90%;
            width:400px;
            text-align:center;
            box-shadow:0 5px 15px rgba(0,0,0,0.3);
        }
        #rewaardsc-countdown {
            display: flex;
            justify-content: center;
            gap: 10px;
            font-weight: bold;
        }
        #rewaardsc-countdown span {
            background: <?php echo esc_attr($countdown_bg_color); ?>;
            color: <?php echo esc_attr($countdown_text_color); ?>;
            padding: 10px 15px;
            border-radius: 10px;
            min-width: 50px;
            text-align: center;
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
            font-family: 'Courier New', monospace;
            transition: transform 0.2s;
        }
        #rewaardsc-countdown span:hover {
            transform: scale(1.1);
            cursor:pointer;
        }
        #rewaardsc-prev-concours,
        #rewaardsc-next-concours {
            background: <?php echo esc_attr($main_color); ?>;
            color: <?php echo esc_attr($text_color); ?>;
            border: none;
            border-radius: 8px;
            padding: 10px 22px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.2s, transform 0.2s;
            margin: 0 5px;
        }
        #rewaardsc-prev-concours:hover,
        #rewaardsc-next-concours:hover {
            background: <?php echo esc_attr($darken_color($main_color, 20)); ?>;
            transform: scale(1.07);
        }
        </style>

        <div id="rewaardsc-concours-pagination"></div>
        <?php if(count($concours_list) > 1): ?>
        <div style="text-align:center; margin:20px 0;">
            <button id="rewaardsc-prev-concours" style="margin-right:10px;"><?php echo esc_html($txt_precedent); ?></button>
            <span id="rewaardsc-pagination-indicator"></span>
            <button id="rewaardsc-next-concours" style="margin-left:10px;"><?php echo esc_html($txt_suivant); ?></button>
        </div>
        <?php endif; ?>

        <div id="rewaardsc-popup">
            <div class="rewaardsc-popup-content">
                <p id="rewaardsc-popup-message" style="font-size:16px; margin-bottom:20px;"></p>
                <div style="display:flex; justify-content:center; gap:10px; flex-wrap:wrap;">
                    <button id="rewaardsc-popup-close" style="padding:10px 20px; background:<?php echo esc_attr($main_color); ?>; color:#fff; border:none; border-radius:5px; cursor:pointer;"><?php echo esc_html($txt_fermer); ?></button>
                    <?php if(!is_user_logged_in()): ?>
                    <a href="<?php echo esc_url($mon_compte_url); ?>" style="padding:10px 20px; background:#28a745; color:#fff; border:none; border-radius:5px; text-decoration:none; display:inline-block; cursor:pointer;"><?php echo esc_html($txt_connexion); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <script>
        var concoursData = <?php echo json_encode($concours_list); ?>;
        var currentConcours = 0;
        var interval = null;
        var showParticipantsCount = <?php echo (int)$show_participants_count; ?>;

        var REWAARDS_I18N = {
            date_debut: "<?php echo esc_js($txt_date_debut); ?>",
            date_fin: "<?php echo esc_js($txt_date_fin); ?>",
            nb_gagnants: "<?php echo esc_js($txt_nb_gagnants); ?>",
            nb_participants: "<?php echo esc_js($txt_nb_participants); ?>",
            tirage: "<?php echo esc_js($txt_tirage); ?>",
            temps_restant: "<?php echo esc_js($txt_temps_restant); ?>",
            tirage_fini: "<?php echo esc_js($txt_tirage_fini); ?>",
            recompenses: "<?php echo esc_js($txt_recompenses); ?>",
            participer: "<?php echo esc_js($txt_participer); ?>",
            connecte: "<?php echo esc_js($txt_connecte); ?>",
            inscrit: "<?php echo esc_js($txt_inscrit); ?>",
            deja_inscrit: "<?php echo esc_js($txt_deja_inscrit); ?>",
            pseudo: "<?php echo esc_js($txt_pseudo); ?>",
            email: "<?php echo esc_js($txt_email); ?>",
            day_short: "<?php echo esc_js(_x('j', 'abréviation de jour pour le compteur', 'reewards')); ?>",
            hour_short: "<?php echo esc_js(_x('h', 'abréviation de heure pour le compteur', 'reewards')); ?>",
            min_short: "<?php echo esc_js(_x('m', 'abréviation de minute pour le compteur', 'reewards')); ?>",
            sec_short: "<?php echo esc_js(_x('s', 'abréviation de seconde pour le compteur', 'reewards')); ?>",
        };

        function renderConcours(index) {
            var c = concoursData[index];
            if(!c) return;
            console.log(c.date_start_raw);
            var html = `
                <div class="rewaardsc-concours-wrapper" style="border:1px solid #ddd; padding:15px; border-radius:10px; margin-bottom:20px; max-width:600px;">
                    <h2 class="rewaardsc-concours-title"><span>${c.nom}</span></h2>
                    <p>📅 <strong>${REWAARDS_I18N.date_debut} :</strong> ${c.date_start}</p>
                    <p>🏁 <strong>${REWAARDS_I18N.date_fin} :</strong> ${c.date_end}</p>
                    <p>🏆 <strong>${REWAARDS_I18N.nb_gagnants} :</strong> ${c.winners_count}</p>
                    ${showParticipantsCount ? `<p>👥 <strong>${REWAARDS_I18N.nb_participants} :</strong> ${c.participants_count}</p>` : ''}
                    <h3 style="margin-top:25px; margin-bottom:10px;">${REWAARDS_I18N.tirage}</h3>
                    <div style="background:#f9f9f9; border:1px solid #ddd; border-radius:10px; padding:20px; margin-bottom:20px; box-shadow:0 4px 10px rgba(0,0,0,0.05); text-align:center; font-size:18px; font-weight:bold; color: red;">
                        ${REWAARDS_I18N.temps_restant}  <br><br> <span id="rewaardsc-countdown"></span>
                    </div>
                    <h3 style="margin-bottom:15px;">${REWAARDS_I18N.recompenses}</h3>
                    <div style="display:flex; flex-wrap:wrap; gap:15px; margin-bottom:20px;">
                        ${(c.rewards||[]).map(function(reward){
                            return `<div class="rewaardsc-reward-card">
                                ${reward.image ? `<img src="${reward.image}" alt="${reward.nom}" style="width:60px; height:60px; object-fit:contain; margin-bottom:10px;">` : `<div style="width:60px; height:60px; margin-bottom:10px; background:#e0e0e0; display:flex; align-items:center; justify-content:center; font-size:24px; color:#bbb;">🎁</div>`}
                                <div style="font-weight:bold;">${reward.nom}</div>
                                <div style="color:#555;">x${reward.qty}</div>
                            </div>`;
                        }).join('')}
                    </div>
                    <div style="text-align:center; margin-top:20px;">
                        <button class="rewaardsc-participer-btn" data-id="${c.ID}">${REWAARDS_I18N.participer}</button>
                    </div>
                </div>
            `;
            document.getElementById('rewaardsc-concours-pagination').innerHTML = html;
            var indicator = document.getElementById('rewaardsc-pagination-indicator');
            if (indicator) {
                indicator.textContent = (index+1) + ' / ' + concoursData.length;
            }

            if (interval) clearInterval(interval);

            var countDownDate = new Date(c.date_end_raw).getTime();
            function updateCountdown() {
                var now = new Date().getTime();
                var distance = countDownDate - now;
                if(distance < 0) {
                    document.getElementById('rewaardsc-countdown').innerHTML = REWAARDS_I18N.tirage_fini;
                    clearInterval(interval);
                    return;
                }
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000*60*60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000*60));
                var seconds = Math.floor((distance % (1000*60)) / 1000);
                document.getElementById('rewaardsc-countdown').innerHTML =
                '<span>' + days + REWAARDS_I18N.day_short + '</span>' +
                '<span>' + hours + REWAARDS_I18N.hour_short + '</span>' +
                '<span>' + minutes + REWAARDS_I18N.min_short + '</span>' +
                '<span>' + seconds + REWAARDS_I18N.sec_short + '</span>';
            }
            updateCountdown();
            interval = setInterval(updateCountdown, 1000);

            var title = document.querySelector('.rewaardsc-concours-title');
            if(title) {
                for(var i=0;i<<?php echo esc_attr($emoji_densite) ?>;i++){
                    var gift = document.createElement('div');
                    gift.className = 'gift';
                    gift.innerHTML = '<?php echo esc_attr($emoji); ?>';
                    gift.style.left = (Math.random()*100)+'%';
                    gift.style.fontSize = (12+Math.random()*18)+'px';
                    gift.style.animationDuration = (3+Math.random()*5)+'s';
                    gift.style.animationDelay = (Math.random()*5)+'s';
                    title.appendChild(gift);
                }
            }
        }

        document.addEventListener('DOMContentLoaded', function(){
            renderConcours(currentConcours);

            var prevBtn = document.getElementById('rewaardsc-prev-concours');
            if (prevBtn) {
                prevBtn.onclick = function(){
                    if(currentConcours > 0) {
                        currentConcours--;
                        renderConcours(currentConcours);
                    }
                };
            }
            var nextBtn = document.getElementById('rewaardsc-next-concours');
            if (nextBtn) {
                nextBtn.onclick = function(){
                    if(currentConcours < concoursData.length-1) {
                        currentConcours++;
                        renderConcours(currentConcours);
                    }
                };
            }

            document.getElementById('rewaardsc-concours-pagination').addEventListener('click', function(e){
                if(e.target.classList.contains('rewaardsc-participer-btn')) {
                    var post_id = e.target.getAttribute('data-id');
                    <?php if(!is_user_logged_in()): ?>
                        showPopup(REWAARDS_I18N.connecte);
                    <?php else: ?>
                        jQuery.ajax({
                            url: '<?php echo esc_url(admin_url('admin-ajax.php')); ?>',
                            type: 'POST',
                            data: { action: 'reewards_participate_ajax', post_id: post_id },
                            success: function(response){
                                if(response.success) {
                                    showPopup(REWAARDS_I18N.inscrit + '<br>' + REWAARDS_I18N.pseudo + ' : <strong>' + response.pseudo + '</strong><br>' + REWAARDS_I18N.email + ' : <strong>' + response.email + '</strong>');
                                } else {
                                    showPopup(REWAARDS_I18N.deja_inscrit + '<br>' + REWAARDS_I18N.pseudo + ' : <strong>' + response.pseudo + '</strong><br>' + REWAARDS_I18N.email + ' : <strong>' + response.email + '</strong>');
                                }
                            }
                        });
                    <?php endif; ?>
                }
            });

            window.showPopup = function(message) {
                document.getElementById('rewaardsc-popup-message').innerHTML = message;
                document.getElementById('rewaardsc-popup').style.opacity = 1;
                document.getElementById('rewaardsc-popup').style.pointerEvents = 'auto';
            };
            document.getElementById('rewaardsc-popup-close').onclick = function(){
                document.getElementById('rewaardsc-popup').style.opacity = 0;
                document.getElementById('rewaardsc-popup').style.pointerEvents = 'none';
            };
            document.getElementById('rewaardsc-popup').onclick = function(e){
                if(e.target === this) {
                    this.style.opacity = 0;
                    this.style.pointerEvents = 'none';
                }
            };
        });
        </script>
        <?php
        return ob_get_clean();
    }

    public static function ajax_participer() {
        if(!is_user_logged_in()) wp_send_json(['success'=>false, 'message'=>__('Tu dois être connecté !', 'reewards')]);

        
        $user = wp_get_current_user();
        


        if(isset($_POST['post_id'])) { //phpcs:ignore WordPress.Security.NonceVerification.Missing
            $post_id = intval( wp_unslash( $_POST['post_id'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
        }

        $participants = get_post_meta($post_id, 'concours_participants', true);
        if(!is_array($participants)) $participants = [];

        foreach($participants as $p) {
            if($p['ID'] == $user->ID) {
                wp_send_json(['success'=>false,'pseudo'=>$user->user_login,'email'=>$user->user_email]);
            }
        }

        $participants[] = ['ID'=>$user->ID,'pseudo'=>$user->user_login,'email'=>$user->user_email];
        update_post_meta($post_id,'concours_participants',$participants);
        wp_send_json(['success'=>true,'pseudo'=>$user->user_login,'email'=>$user->user_email]);
    }
}

// Enregistrement du shortcode et de l'AJAX après la classe
add_shortcode('reewards_participate', [ParticipationShortcode::class, 'render']);
add_action('wp_ajax_reewards_participate_ajax', [ParticipationShortcode::class, 'ajax_participer']);
add_action('wp_ajax_nopriv_reewards_participate_ajax', [ParticipationShortcode::class, 'ajax_participer']);