<?php
namespace Reewards\Utils;

use Reewards\Domain\TirageService;

if (!defined('ABSPATH')) exit;

class Cron
{
    /**
     * Ajoute un intervalle personnalisé au cron WP
     */
    public static function registerSchedule($schedules) {
        $schedules['one_minute'] = [
            'interval' => 60,
            'display'  => __('Toutes les minutes - Reewards', 'reewards')
        ];
        return $schedules;
    }

    /**
     * Planifie l'événement cron si besoin
     */
    public static function scheduleEvent() {
        if (!wp_next_scheduled('rewaardsc_cron_event')) {
            wp_schedule_event(time(), 'one_minute', 'rewaardsc_cron_event');
        }
    }

    /**
     * Fonction principale appelée par le cron
     */
    public static function verifierTirages() {
        $now = current_time('Y-m-d H:i:s');

        update_option('rewaardsc_last_cron_run', $now);

        $args = [
            'post_type'      => 'rewaards_concours',
            'posts_per_page' => -1,
            'meta_query'     => [
                'relation' => 'AND',
                [
                    'key'     => 'concours_status',
                    'value'   => 'en_cours',
                ],
                [
                    'key'     => 'concours_end',
                    'value'   => $now,
                    'compare' => '<',
                    'type'    => 'DATETIME'
                ],
                [
                    'key'     => 'concours_tirage_effectue',
                    'compare' => 'NOT EXISTS'
                ]
            ]
        ];

        $query = new \WP_Query($args);

        if (!$query->have_posts()) {
            TirageService::log(__('Aucun concours à traiter', 'reewards'));
            return;
        }

        while ($query->have_posts()) {
            $query->the_post();
            $post_id = get_the_ID();
            // translators: %d is the contest ID.
            TirageService::log(sprintf(__('Tirage en cours pour le concours ID=%d', 'reewards'), $post_id));

            // Lancer le tirage via le service
            TirageService::lancerTirage($post_id);

            // Mettre le statut du concours en "termine"
            update_post_meta($post_id, 'concours_status', 'termine');
        }

        wp_reset_postdata();
    }
}