<?php
namespace Reewards\Utils;

if (!defined('ABSPATH')) exit;

class Format {
    /**
     * Affiche une date selon le format admin
     */
    public static function date($date) {
        $format = get_option('rewaardsc_date_format', get_option('date_format', 'd/m/Y'));
        return date_i18n($format, strtotime($date));
    }

    /**
     * Affiche une heure selon le format admin
     */
    public static function time($date) {
        $format = get_option('rewaardsc_time_format', get_option('time_format', 'H:i'));
        return date_i18n($format, strtotime($date));
    }

    /**
     * Affiche une date + heure selon le format admin
     */
    public static function datetime($date) {
        $format = get_option('rewaardsc_date_format', get_option('date_format', 'd/m/Y') . ' ' . get_option('time_format', 'H:i'));
        return date_i18n($format, strtotime($date));
    }
}