<?php
namespace Reewards\Utils;

if (!defined('ABSPATH')) exit;

class LicenceCron
{
    /**
     * Planifie le cron à l'activation du plugin
     */
    public static function scheduleEvent() {
        if (!wp_next_scheduled('rewaardsc_check_license_cron')) {
            wp_schedule_event(time(), 'daily', 'rewaardsc_check_license_cron');
        }
    }

    /**
     * Supprime le cron à la désactivation du plugin
     */
    public static function clearEvent() {
        wp_clear_scheduled_hook('rewaardsc_check_license_cron');
    }

    /**
     * Callback du cron pour vérifier la licence
     */
    public static function checkLicense() {
        $key = get_option('rewaardsc_pro_license_key', '');
        if (!$key) return;

        $response = wp_remote_post('https://mg-plugins.com/wp-json/mg-licences/v1/verify', [
            'headers' => ['Content-Type' => 'application/json'],
            'body'    => json_encode([
                'licence_key' => $key,
                'site_url'    => preg_replace('#^https?://#', '', get_site_url()),
                'plugin_id'   => '140',
            ]),
            'timeout' => 10,
        ]);

        if (is_wp_error($response)) {
            update_option('rewaardsc_pro_license_status', 'invalid');
        } else {
            $body = json_decode(wp_remote_retrieve_body($response), true);
            if (!empty($body['success'])) {
                update_option('rewaardsc_pro_license_status', 'valid');
                update_option('rewaardsc_pro_license_expiration', $body['expiration'] ?? '');
            } else {
                update_option('rewaardsc_pro_license_status', 'invalid');
            }
        }
    }
}