<?php

namespace Reewards\Utils;

if (!function_exists('reewards_pro_field')) {
    /**
     * Affiche un champ réservé PRO (checkbox, range, etc.)
     * @param string $type Type de champ ('checkbox', 'range', etc.)
     * @param array $args Attributs du champ (name, value, checked, min, max, etc.)
     * @param string $feature_id Identifiant unique pour la popup JS
     * @param bool $is_pro L'utilisateur est-il PRO ?
     * @param bool $has_plugin_pro Le plugin PRO est-il actif ?
     */
    function reewards_pro_field($type, $args, $feature_id, $is_pro, $has_plugin_pro = false) {
        // Désactive si pas PRO ou plugin PRO manquant
        $disabled = (!$is_pro || !$has_plugin_pro) ? 'disabled' : '';
        $class = (!$is_pro || !$has_plugin_pro) ? 'rewaardsc-pro-field' : '';
        $data = 'data-feature="' . esc_attr($feature_id) . '"';
        $checked = !empty($args['checked']) ? 'checked' : '';
        $value = isset($args['value']) ? esc_attr($args['value']) : '1';

        if ($type === 'checkbox') {
            echo   '<input type="checkbox" name="' . esc_attr($args['name']) . '" value="' . esc_attr($value) . '" ' . esc_attr($checked) . ' ' . esc_attr($disabled) . ' class="' . esc_attr($class) . '" ' . esc_attr($data) . ' />' ;
        }
        if ($type === 'range') {
            $min = isset($args['min']) ? intval($args['min']) : 0;
            $max = isset($args['max']) ? intval($args['max']) : 100;
            echo '<input type="range" name="' . esc_attr($args['name']) . '" min="' . esc_attr($min) . '" max="' . esc_attr($max) . '" value="' . esc_attr($value) . '" ' . esc_attr($disabled) . ' class="' . esc_attr($class) . '" ' . esc_attr($data) . ' style="background:#f9f9f9;" />';
            echo '<span id="emoji-density-value">' . esc_html($value) . '</span>%';
        }
        if (!$is_pro) {
            echo '<span class="rewaardsc-pro-label" style="color:#ff9800; margin-left:10px; font-weight:bold;">PRO</span>';
        }
    }
}